﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

enum ConvertCheckFlag
{
    CHECK_NONE                               = 0x0,
    CHECK_VERSION                            = 0x1 << 0,
    CHECK_SHADER_ASSIGN                      = 0x1 << 1,
    CHECK_TEXTURE_NAME                       = 0x1 << 2,
    CHECK_PARAM_ANIM_ASSIGN                  = 0x1 << 3,
    CHECK_CHOICE_DEFAULT                     = 0x1 << 4,

#if defined(_DEBUG)
    CHECK_BINARY_DEFAULT =
        CHECK_SHADER_ASSIGN                 |
        CHECK_TEXTURE_NAME                  |
        CHECK_PARAM_ANIM_ASSIGN,

    CHECK_SHADER_DEFAULT =
        CHECK_CHOICE_DEFAULT
#else
    CHECK_BINARY_DEFAULT =
        CHECK_VERSION                       |
        CHECK_SHADER_ASSIGN                 |
        CHECK_TEXTURE_NAME                  |
        CHECK_PARAM_ANIM_ASSIGN,

    CHECK_SHADER_DEFAULT =
        CHECK_VERSION                       |
        CHECK_CHOICE_DEFAULT
#endif
};

enum ErrorCodeBase
{
    ERRCODE_BASE                                    = 0x0000,
    ERRCODE_XML_BASE                                = 0x0100,
    ERRCODE_IMG_BASE                                = 0x0200,
    ERRCODE_FILE_BASE                               = 0x1000,
    ERRCODE_MODEL_BASE                              = 0x1100,
    ERRCODE_SKELETON_BASE                           = 0x1200,
    ERRCODE_SHAPE_BASE                              = 0x1300,
    ERRCODE_VERTEX_BASE                             = 0x1400,
    ERRCODE_MATERIAL_BASE                           = 0x1500,
    ERRCODE_TEXTURE_BASE                            = 0x1600,
    ERRCODE_ANIM_BASE                               = 0x1700,
    ERRCODE_SHADER_CONVERTER_BASE                   = 0x1800,
    ERRCODE_SHADER_ARCHIVER_BASE                    = 0x1900,
    ERRCODE_SHADER_ANNOTATION_BASE                  = 0x1a00,
};

enum ErrorCode
{
    ERRCODE_INTERNAL                                = ERRCODE_BASE + 0x1,
    ERRCODE_UNSUPPORTED                             = ERRCODE_BASE + 0x2,
    ERRCODE_NOT_IMPLEMENTED                         = ERRCODE_BASE + 0x3,
    ERRCODE_INVALID_FILENAME                        = ERRCODE_BASE + 0x4,
    ERRCODE_INVALID_OPTIONFILE                      = ERRCODE_BASE + 0x5,
    ERRCODE_UNSUPPORTED_FILETYPE                    = ERRCODE_BASE + 0x6,
    ERRCODE_ENDIAN_SWAP_MISMATCH                    = ERRCODE_BASE + 0x7,
    ERRCODE_UNINITIALIZED_MEMORY                    = ERRCODE_BASE + 0x8,
    ERRCODE_INCONSISTENT_DICTIONARY                 = ERRCODE_BASE + 0x9,
    ERRCODE_UNKNOWN_ENUM                            = ERRCODE_BASE + 0xa,
    ERRCODE_UNKNOWN_OPTION                          = ERRCODE_BASE + 0xb,
    ERRCODE_OPEN_GL_ERROR                           = ERRCODE_BASE + 0xc,
    ERRCODE_INVALID_DLL_INITIALIZED                 = ERRCODE_BASE + 0xd,
    ERRCODE_OPEN_FILE                               = ERRCODE_BASE + 0xe,
    ERRCODE_INVALID_DIRECTORY_NAME                  = ERRCODE_BASE + 0xf,
    ERRCODE_ZLIB_ERROR                              = ERRCODE_BASE + 0x10,
    ERRCODE_CAST_OVERFLOW                           = ERRCODE_BASE + 0x11,
    ERRCODE_INVALID_CORE                            = ERRCODE_BASE + 0x12,
    ERRCODE_INVALID_OPTION_SET                      = ERRCODE_BASE + 0x13
};

enum ErrorCodeImg
{
    ERRCODE_IMG_INVALID_FORMT                       = ERRCODE_IMG_BASE + 0x1,
    ERRCODE_IMG_INVALID_DATA                        = ERRCODE_IMG_BASE + 0x2
};

enum ErrorCodeXml
{
    ERRCODE_XML_ELEMENT_NOT_FOUND                   = ERRCODE_XML_BASE + 0x01,
    ERRCODE_XML_ATTRIBUTE_NOT_FOUND                 = ERRCODE_XML_BASE + 0x02,
    ERRCODE_XML_UNKNOWN_ENUM                        = ERRCODE_XML_BASE + 0x03,
    ERRCODE_XML_STREAM_TOO_SHORT                    = ERRCODE_XML_BASE + 0x04,
    ERRCODE_XML_OUT_OF_RANGE                        = ERRCODE_XML_BASE + 0x05,
    ERRCODE_XML_CONVERT_PARSE_FAILURE               = ERRCODE_XML_BASE + 0x06,
    ERRCODE_XML_BINARY_STREAM_FAILURE               = ERRCODE_XML_BASE + 0x07,
    ERRCODE_XML_INVALID_BINARY_STREAM_TYPE          = ERRCODE_XML_BASE + 0x08,
    ERRCODE_XML_INVALID_VERSION                     = ERRCODE_XML_BASE + 0x09,
    ERRCODE_XML_VERSION_MISMATCH                    = ERRCODE_XML_BASE + 0x0a,
    ERRCODE_XML_INVALID_STREAM                      = ERRCODE_XML_BASE + 0x0b,
    ERRCODE_XML_INVALID_USERDATA                    = ERRCODE_XML_BASE + 0x0c,
    ERRCODE_XML_INVALID_ATTRIBUTE_TYPE              = ERRCODE_XML_BASE + 0x0d,
    ERRCODE_XML_INVALID_QUANTIZE_TYPE               = ERRCODE_XML_BASE + 0x0e,
    ERRCODE_XML_ANIMATION_NOT_FOUND                 = ERRCODE_XML_BASE + 0x0f,
    ERRCODE_XML_INVALID_STREAM_TYPE                 = ERRCODE_XML_BASE + 0x10,
    ERRCODE_XML_SHAPE_SHADER_ASSIGN_NOT_FOUND       = ERRCODE_XML_BASE + 0x11,
    ERRCODE_XML_SHADER_ASSIGN_NOT_FOUND             = ERRCODE_XML_BASE + 0x12,
    ERRCODE_XML_SHAPE_INVALID_VERTEX_INDEX          = ERRCODE_XML_BASE + 0x13,
    ERROCDE_XML_INVALID_CAMERA_ANIM_TARGET          = ERRCODE_XML_BASE + 0x14,
    ERROCDE_XML_INVALID_LIGHT_ANIM_TARGET           = ERRCODE_XML_BASE + 0x15,
    ERROCDE_XML_INVALID_FOG_ANIM_TARGET             = ERRCODE_XML_BASE + 0x16,
    ERRCODE_XML_BONE_NAME_NOT_FOUND                 = ERRCODE_XML_BASE + 0x17,
    ERRCODE_XML_MATERIAL_NAME_NOT_FOUND             = ERRCODE_XML_BASE + 0x18,
    ERRCODE_XML_TEXTURE_NAME_NOT_FOUND              = ERRCODE_XML_BASE + 0x19,
    ERRCODE_XML_SAMPLER_NAME_NOT_FOUND              = ERRCODE_XML_BASE + 0x1a,
    ERRCODE_XML_TARGET_ATTRIB_NAME_NOT_FOUND        = ERRCODE_XML_BASE + 0x1b,
    ERRCODE_XML_INVALID_TARGET_ATTRIB_COUNT         = ERRCODE_XML_BASE + 0x1c,
    ERRCODE_XML_INVALID_VERTEX_ATTRIB_COUNT         = ERRCODE_XML_BASE + 0x1d,
    ERRCODE_XML_RENDER_INFO_COUNT                   = ERRCODE_XML_BASE + 0x1e,
    ERRCODE_XML_INVALID_TEXTURE_FORMAT              = ERRCODE_XML_BASE + 0x1f,
    ERRCODE_XML_INVALID_LOD_OFFSET                  = ERRCODE_XML_BASE + 0x20,
    ERRCODE_XML_INVALID_SHADING_MODEL_NAME          = ERRCODE_XML_BASE + 0x21,
    ERRCODE_XML_DEPLICATED_ELEMENT                  = ERRCODE_XML_BASE + 0x22,
    ERRCODE_XML_SYSTEM_BLOCK_DUPLICATION            = ERRCODE_XML_BASE + 0x23,
    ERRCODE_XML_INVALID_SHADER_STORAGE_BLOCK_TYPE   = ERRCODE_XML_BASE + 0x24,
};

enum ErrorCodeFile
{
    ERRCODE_FILE_NAME_OVERLAPPED                    = ERRCODE_FILE_BASE + 0x1,
    ERRCODE_DUPLICAED_MATERIAL_ANIM_FILE_TYPE       = ERRCODE_FILE_BASE + 0x2,
    ERRCODE_INVALID_MATERIAL_ANIM_FILE_TYPE         = ERRCODE_FILE_BASE + 0x3,
};

enum ErrorCodeConvert
{
    ERRCODE_VERTEX_INVALID_QUANTIZE_VALUE           = ERRCODE_VERTEX_BASE + 0x1,
    ERRCODE_VERTEX_INVALID_ATTRIB_INDEX             = ERRCODE_VERTEX_BASE + 0x2,
    ERRCODE_VERTEX_INVALID_BONE_INDEX               = ERRCODE_VERTEX_BASE + 0x3,
    ERRCODE_ANIM_INVALID_QUANTIZE_TYPE              = ERRCODE_ANIM_BASE + 0x1
};

enum ErrorCodeShape
{
    ERRCODE_SHAPE_INVALID_VERTEX_INDEX              = ERRCODE_SHAPE_BASE + 0x1,
    ERRCODE_SHAPE_TOO_MANY_VERTICES                 = ERRCODE_SHAPE_BASE + 0x2,
    ERRCODE_SHAPE_INVALID_MESH                      = ERRCODE_SHAPE_BASE + 0x3,
    ERRCODE_SHAPE_INVALID_BOUNDING_TREE             = ERRCODE_SHAPE_BASE + 0x4,
    ERRCODE_SHAPE_INVALID_SUBMESH_COUNT             = ERRCODE_SHAPE_BASE + 0x5,
    ERRCODE_SHAPE_INVALID_VERTEX                    = ERRCODE_SHAPE_BASE + 0x6,
    ERRCODE_SHAPE_INVALID_KEY_SHAPE                 = ERRCODE_SHAPE_BASE + 0x7
};

enum ErrorCodeSkeleton
{
    ERRCODE_SKELETON_INVALID_BONE = ERRCODE_SKELETON_BASE + 0x1
};

enum ErrorCodeShaderConverter
{
    ERRCODE_SHADER_CONVERTER_GSH_COMPILE                             = ERRCODE_SHADER_CONVERTER_BASE + 0x1,
    ERRCODE_SHADER_CONVERTER_GL_COMPILE                              = ERRCODE_SHADER_CONVERTER_BASE + 0x2,
    ERRCODE_SHADER_CONVERTER_LINK                                    = ERRCODE_SHADER_CONVERTER_BASE + 0x3,
    ERRCODE_SHADER_CONVERTER_ATTRIBUTE                               = ERRCODE_SHADER_CONVERTER_BASE + 0x4,
    ERRCODE_SHADER_CONVERTER_INVALID_OPTION_NAME                     = ERRCODE_SHADER_CONVERTER_BASE + 0x5,
    ERRCODE_SHADER_CONVERTER_INVALID_OPTION_CHOICE                   = ERRCODE_SHADER_CONVERTER_BASE + 0x6,
    ERRCODE_SHADER_CONVERTER_INVALID_OPTION_DEFAULT_VALUE_FORMAT     = ERRCODE_SHADER_CONVERTER_BASE + 0x7,
    ERRCODE_SHADER_CONVERTER_INVALID_OPTION_DEFAULT_VALUE_NOT_FOUND  = ERRCODE_SHADER_CONVERTER_BASE + 0x8,
    ERRCODE_SHADER_CONVERTER_INVALID_TEMP_DIRECTORY_PATH             = ERRCODE_SHADER_CONVERTER_BASE + 0x9,
    ERRCODE_SHADER_CONVERTER_INVALID_UNIFORM_BLOCK                   = ERRCODE_SHADER_CONVERTER_BASE + 0xa,
    ERRCODE_SHADER_CONVERTER_UNIFORM_BLOCK_NOT_FOUND                 = ERRCODE_SHADER_CONVERTER_BASE + 0xb,
    ERRCODE_SHADER_CONVERTER_INVALID_UNIFORM                         = ERRCODE_SHADER_CONVERTER_BASE + 0xc,
    ERRCODE_SHADER_CONVERTER_UNIFORM_NOT_FOUND                       = ERRCODE_SHADER_CONVERTER_BASE + 0xd,
    ERRCODE_SHADER_CONVERTER_INVALID_OPTION_FILTER                   = ERRCODE_SHADER_CONVERTER_BASE + 0xe,
    ERRCODE_SHADER_CONVERTER_SOURCEFILE_NOT_FOUND                    = ERRCODE_SHADER_CONVERTER_BASE + 0xf,
    ERRCODE_SHADER_CONVERTER_INVALID_SOURCEFILE_CODE_PAGE            = ERRCODE_SHADER_CONVERTER_BASE + 0x10,
    ERRCODE_SHADER_CONVERTER_INVALID_ANNOTATION                      = ERRCODE_SHADER_CONVERTER_BASE + 0x11,
    ERRCODE_SHADER_CONVERTER_XML_VARIATION_ID                        = ERRCODE_SHADER_CONVERTER_BASE + 0x12,
    ERRCODE_SHADER_CONVERTER_INVALID_UNIFORM_BLOCK_DEFINITION        = ERRCODE_SHADER_CONVERTER_BASE + 0x13,
    ERRCODE_SHADER_CONVERTER_GLSL_SYNTAX_ERROR                       = ERRCODE_SHADER_CONVERTER_BASE + 0x14,
    ERRCODE_SHADER_CONVERTER_EXTRACTION_ERROR                        = ERRCODE_SHADER_CONVERTER_BASE + 0x15,
    ERRCODE_SHADER_CONVERTER_EXPANDING_ERROR                         = ERRCODE_SHADER_CONVERTER_BASE + 0x16,
    ERRCODE_SHADER_CONVERTER_ALTERNATIVE_OPTION_NOT_FOUND            = ERRCODE_SHADER_CONVERTER_BASE + 0x17,
    ERRCODE_SHADER_CONVERTER_INVALID_BRACH_CHOICE                    = ERRCODE_SHADER_CONVERTER_BASE + 0x18,
    ERRCODE_SHADER_CONVERTER_INVALID_OPTION_UNIFORM                  = ERRCODE_SHADER_CONVERTER_BASE + 0x19,
    ERRCODE_SHADER_CONVERTER_SHADER_VARIATION_VALUE_NOT_FOUND        = ERRCODE_SHADER_CONVERTER_BASE + 0x1a,
    ERRCODE_SHADER_CONVERTER_SHADER_VARIATION_DEFAULT_NOT_FOUND      = ERRCODE_SHADER_CONVERTER_BASE + 0x1b,
    ERRCODE_SHADER_CONVERTER_SHADER_CONFIG_INVALID_DEFAULT_VALUE     = ERRCODE_SHADER_CONVERTER_BASE + 0x1c,
    ERRCODE_SHADER_CONVERTER_SHADER_CONFIG_INVALID_CHOICE            = ERRCODE_SHADER_CONVERTER_BASE + 0x1d,
    ERRCODE_SHADER_CONVERTER_VARIATION_NOT_CREATED                   = ERRCODE_SHADER_CONVERTER_BASE + 0x1e,
    ERRCODE_SHADER_CONVERTER_OVERLAP_OPTION                          = ERRCODE_SHADER_CONVERTER_BASE + 0x1f,
    ERRCODE_SHADER_CONVERTER_VARIATION_MACRO_NOT_CONSISTENT          = ERRCODE_SHADER_CONVERTER_BASE + 0x20,
    ERRCODE_SHADER_CONVERTER_REDIFINED_SYMBOL                        = ERRCODE_SHADER_CONVERTER_BASE + 0x21,
    ERRCODE_SHADER_CONVERTER_LOCATION_INCONSISTENT                   = ERRCODE_SHADER_CONVERTER_BASE + 0x22,
    ERRCODE_SHADER_CONVERTER_INVALID_SHADER_STAGE                    = ERRCODE_SHADER_CONVERTER_BASE + 0x23,
    ERRCODE_SHADER_CONVERTER_GLSL_VERSION_NOT_FOUND                  = ERRCODE_SHADER_CONVERTER_BASE + 0x24,
    ERRCODE_SHADER_CONVERTER_VERSION_MISMATCH                        = ERRCODE_SHADER_CONVERTER_BASE + 0x25,
    ERRCODE_SHADER_CONVERTER_NO_COHERENCE                            = ERRCODE_SHADER_CONVERTER_BASE + 0x26,
};

enum ErrorCodeShaderAnnotation
{
    ERRCODE_SHADER_ANNOTATION_ID_LOCATION                  = ERRCODE_SHADER_ANNOTATION_BASE + 0x1,
    ERRCODE_SHADER_ANNOTATION_ID_NOT_FOUND                 = ERRCODE_SHADER_ANNOTATION_BASE + 0x2,
    ERRCODE_SHADER_ANNOTATION_REMOTE_ID_NOT_DEFINED        = ERRCODE_SHADER_ANNOTATION_BASE + 0x3,
    ERRCODE_SHADER_ANNOTATION_ID_REDEFINED                 = ERRCODE_SHADER_ANNOTATION_BASE + 0x4,
    ERRCODE_SHADER_ANNOTATION_STAGE_INCONSISTENT           = ERRCODE_SHADER_ANNOTATION_BASE + 0x5,
    ERRCODE_SHADER_ANNOTATION_XML_SYNTAX_ERROR             = ERRCODE_SHADER_ANNOTATION_BASE + 0x6,
    ERRCODE_SHADER_ANNOTATION_INVALID_DEFAULT              = ERRCODE_SHADER_ANNOTATION_BASE + 0x7,
    ERRCODE_SHADER_ANNOTATION_INVALID_STREAMOUT            = ERRCODE_SHADER_ANNOTATION_BASE + 0x8,
    ERRCODE_SHADER_ANNOTATION_INVALID_REVISION             = ERRCODE_SHADER_ANNOTATION_BASE + 0x9,
    ERRCODE_SHADER_ANNOTATION_RECURSIVE_UI_GROUP           = ERRCODE_SHADER_ANNOTATION_BASE + 0xa,
    ERRCODE_SHADER_ANNOTATION_INVALID_ANNOTATION           = ERRCODE_SHADER_ANNOTATION_BASE + 0xb,
};

enum ErrorCodeShaderArchiver
{
    ERRCODE_SHADER_ARCHIVER_INVALID_PROGRAM_INDEX    = ERRCODE_SHADER_ARCHIVER_BASE + 0x1
};
