﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nw { namespace g3d { namespace tool {
namespace util {

class Buffer
{
public:
    Buffer() : m_pData(), m_Size(0) {}

    void* Get() { return m_pData.get(); }
    const void* Get() const { return m_pData.get(); }
    size_t Size() const { return m_Size; }

    void Reset() { m_pData.reset(); m_Size = 0; }

    void Alloc(size_t size, size_t alignment = 4);
    bool LoadFile(const wchar_t* path, size_t alignment = 4);
    bool SaveFile(const wchar_t* path);

private:
    std::shared_ptr<void> m_pData;
    size_t m_Size;
};

} // namespace util

} // namespace tool
} // namespace g3d
} // namespace nw
