﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <g3dif/TexPatternAnim.h>

namespace nw { namespace g3d { namespace tool {
namespace g3dif {

void elem_pattern_anim_target::operator<<(const util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());

    try
    {
        sampler_name << pElem;
        base_value << pElem;

        curve.Validate();
        if (!curve->Read(pElem))
        {
            curve.Invalidate();
        }
    }
    CATCH_THROW_XML_ERROR()
}

void elem_tex_pattern_mat_anim::operator<<(const util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());

    try
    {
        mat_name << pElem;

        for (const util::XMLElement* pTarget = pElem->Child(elem_pattern_anim_target::Id());
            pTarget; pTarget = pTarget->NextSibling(elem_pattern_anim_target::Id()))
        {
            pattern_anim_target_array.push_back(elem_pattern_anim_target());
            pattern_anim_target_array.back() << pTarget;
        }
    }
    CATCH_THROW_XML_ERROR()
}

void elem_tex_pattern::operator<<(const util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());


    try
    {
        pattern_index << pElem;
        tex_name << pElem;
    }
    CATCH_THROW_XML_ERROR()
}

void elem_tex_pattern_anim_info::operator<<(const util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());

    try
    {
        frame_count << pElem;
        loop << pElem;
    }
    CATCH_THROW_XML_ERROR()
}

void elem_tex_pattern_anim::operator<<(const util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());

    try
    {
        version << pElem;
        tex_pattern_anim_info << pElem->Child(elem_tex_pattern_anim_info::Id());
        tex_pattern_array <<pElem->Child(elem_tex_pattern::IdArray());
        tex_pattern_mat_anim_array << pElem->Child(elem_tex_pattern_mat_anim::IdArray());
        stream_array << pElem->Child(elem_stream::IdArray());
        user_data_array << pElem->Child(elem_user_data::IdArray());
    }
    CATCH_THROW_XML_ERROR()
}

void elem_tex_pattern_anim::PostProcess()
{
    // 参照の解決。
    for (auto iter = tex_pattern_mat_anim_array.begin(); iter != tex_pattern_mat_anim_array.end(); ++iter)
    {
        for (auto iterTarget = iter->pattern_anim_target_array.begin(); iterTarget != iter->pattern_anim_target_array.end(); ++ iterTarget)
        {
            if (iterTarget->curve)
            {
                elem_anim_curve& curve = iterTarget->curve.Get();
                try
                {
                    int stream_array_size = static_cast<int>(stream_array.size());

                    if (stream_array_size <= curve.stream_index.value)
                    {
                        THROW_ERROR(ERRCODE_XML_OUT_OF_RANGE,
                            "Out of range. stream_array: %d tex_pattern_anim.stream_index: %d",
                            stream_array_size, curve.stream_index.value);
                    }
                    // テキストデータを解析します。
                    elem_stream& xmlStream = stream_array[curve.stream_index.value];
                    curve.stream.rawdata = AnalizeAndCopyData(xmlStream.textData, xmlStream.count.value, xmlStream.GetStreamType());
                    curve.stream.count = xmlStream.count.value;
                    curve.stream.type = static_cast<StreamType>(xmlStream.type.value);
                }
                CATCH_THROW_XML_ERROR()
            }
        }
    }

    // ユーザーデータの解析
    for (auto iter = user_data_array.begin(); iter != user_data_array.end(); ++iter)
    {
        iter->PostProcess(stream_array);
    }
}

void elem_tex_pattern_anim::PostBinaryProcess(void* data)
{
    try
    {
        StreamArray streamArray;
        AnalizeBinaryData(streamArray, data);

        int stream_array_size = static_cast<int>(streamArray.streamChunk.size());

        // 参照の解決。
        for (auto iter = tex_pattern_mat_anim_array.begin(); iter != tex_pattern_mat_anim_array.end(); ++iter)
        {
            for (auto iterTarget = iter->pattern_anim_target_array.begin(); iterTarget != iter->pattern_anim_target_array.end(); ++ iterTarget)
            {
                if (iterTarget->curve)
                {
                    elem_anim_curve& curve = iterTarget->curve.Get();

                    if (stream_array_size <= curve.stream_index.value)
                    {
                        THROW_ERROR(ERRCODE_XML_OUT_OF_RANGE,
                            "Out of range. stream_array: %d tex_pattern_anim.stream_index: %d",
                            stream_array_size, curve.stream_index.value);
                    }
                    void* rawdata = CopyRawData(streamArray.streamChunk[curve.stream_index.value]);
                    curve.stream.rawdata.reset(rawdata, free);
                    curve.stream.count = streamArray.streamChunk[curve.stream_index.value].count;
                    curve.stream.type = streamArray.streamChunk[curve.stream_index.value].type;
                }
            }
        }

        for (auto iter = user_data_array.begin(); iter != user_data_array.end(); ++iter)
        {
            iter->PostBinaryProcess(streamArray);
        }
    }
    CATCH_THROW_XML_ERROR()
}

void
elem_tex_pattern_anim::CheckData(int flag)
{
    for (auto iterPattern = tex_pattern_array.cbegin(); iterPattern != tex_pattern_array.cend(); ++iterPattern)
    {
        if (iterPattern->tex_name.value.empty())
        {
            if (util::CheckFlag(flag, CHECK_TEXTURE_NAME))
            {
#if defined(_DEBUG)
                PRINT_WARNING(
                    ERRCODE_XML_TEXTURE_NAME_NOT_FOUND,
                    "tex_name was not found in the tex_pattern_anim (%hs).", name.c_str());
#else
                THROW_ERROR(
                    ERRCODE_XML_TEXTURE_NAME_NOT_FOUND,
                    "tex_name was not found in the tex_pattern_anim (%hs).", name.c_str());
#endif
            }
        }
    }
}

} // namespace g3dif

} // namespace tool
} // namespace g3d
} // namespace nw
