﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma warning(push)
#pragma warning(disable:4091)
#include <g3dif/ShaderConfig.h>
#include <algorithm>

#pragma warning(pop)
namespace nw { namespace g3d { namespace tool {
namespace g3dif {

namespace
{

const util::StringRef str_wild_card              = "*";

}

//--------------------------------------------------------------------------------------------------

void elem_include_path::operator<<(const util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());

    try
    {
        path << pElem;
    }

    CATCH_THROW_XML_ERROR()
}

void elem_force_include_file::operator<<(const util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());

    try
    {
        path << pElem;
    }

    CATCH_THROW_XML_ERROR()
}

void elem_stage::operator<<(const util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());

    try
    {
        path << pElem;
    }
    CATCH_THROW_XML_ERROR()
}

void elem_macro::operator<<(const util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());

    try
    {
        name << pElem;
        value << pElem;
    }
    CATCH_THROW_XML_ERROR()
}

void elem_variation::operator<<(const util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());

    try
    {
        id << pElem;
        choice << pElem;
        default_value << pElem;
        branch << pElem;
    }
    CATCH_THROW_XML_ERROR()
}

void elem_shader::operator<<(const util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());

    try
    {
        name << pElem;
        material_shader << pElem;
        for (int stageIndex = 0; stageIndex < ShaderStage_StageCount; ++stageIndex)
        {
            try
            {
                shader_path[stageIndex] << pElem->Child(elem_stage::Id(stageIndex));
            }
            catch (nw::g3d::tool::util::Exception&)
            {
                PRINT_ERROR_LOG("<%hs>", elem_stage::Id(stageIndex).str);
                PRINT_TRACE();
                throw;
            }
        }
        macro_array << pElem->Child(elem_macro::IdArray());
        variation_array << pElem->Child(elem_variation::IdArray());
    }
    CATCH_THROW_XML_ERROR()
}

void elem_shader_config_info::operator<<(const util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());

    try
    {
        code_page << pElem;
    }
    CATCH_THROW_XML_ERROR()
}

void elem_shader_config::operator<<(const util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());

    try
    {
        version << pElem;
        shader_config_info << pElem->Child(elem_shader_config_info::Id());
        include_path_array << pElem->Child(elem_include_path::IdArray());
        force_include_file_array << pElem->Child(elem_force_include_file::IdArray());
        shader_array << pElem->Child(elem_shader::IdArray());
    }
    CATCH_THROW_XML_ERROR()
}

void elem_shader_config::PostProcess()
{
    try
    {
        for (auto shader = shader_array.begin(); shader != shader_array.end(); ++shader)
        {
            shader->Expand();
        }
    }
    CATCH_THROW_XML_ERROR()
}

void elem_shader_config::CheckData(int /*flag*/)
{
    for (auto shader = shader_array.begin(); shader != shader_array.end(); ++shader)
    {
        for (auto variation = shader->variation_array.begin(); variation != shader->variation_array.end(); ++variation)
        {
            if (variation->choice.value.empty())
            {
                THROW_ERROR(ERRCODE_SHADER_CONVERTER_SHADER_CONFIG_INVALID_CHOICE,
                    "Invalid choice in the variation(%hs:%hs).", variation->id.value.c_str(), shader->name.value.c_str());
            }
        }
    }
}

void elem_shader::Expand()
{
    for (auto variation = variation_array.begin(); variation != variation_array.end(); ++variation)
    {
        VariationValue value;
        value.choice = variation->choice.value;
        if (variation->choice.value.empty())
        {
            // 空白の場合はシェーダ側の定義を使用する意味で * に変換する。
            value.choice = str_wild_card.Str();
        }
        value.default_value = variation->default_value.value;
        value.branch = variation->branch.value;
        option_filter.insert(std::make_pair(variation->id.value, value));
    }
}

} // namespace g3dif

} // namespace tool
} // namespace g3d
} // namespace nw
