﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <g3dif/Identifier.h>

namespace nw { namespace g3d { namespace tool {
namespace g3dif {

const util::LiteralStr tbl_identifier[] = {
    S11N_DEFINE_ENUM_ID(alignment),
    S11N_DEFINE_ENUM_ID(alpha_dst_func),
    S11N_DEFINE_ENUM_ID(alpha_op),
    S11N_DEFINE_ENUM_ID(alpha_src_func),
    S11N_DEFINE_ENUM_ID(alpha_test),
    S11N_DEFINE_ENUM_ID(alt),
    S11N_DEFINE_ENUM_ID(angle_attn_func),
    S11N_DEFINE_ENUM_ID(attrib_assign),
    S11N_DEFINE_ENUM_ID(attrib_assign_array),
    S11N_DEFINE_ENUM_ID(attrib_index),
    S11N_DEFINE_ENUM_ID(attrib_name),
    S11N_DEFINE_ENUM_ID(attrib_var),
    S11N_DEFINE_ENUM_ID(attrib_var_array),
    S11N_DEFINE_ENUM_ID(base_name),
    S11N_DEFINE_ENUM_ID(base_value),
    S11N_DEFINE_ENUM_ID(base_vertex),
    S11N_DEFINE_ENUM_ID(bias),
    S11N_DEFINE_ENUM_ID(billboard),
    S11N_DEFINE_ENUM_ID(binarize),
    S11N_DEFINE_ENUM_ID(binarize_scale),
    S11N_DEFINE_ENUM_ID(binarize_rotate),
    S11N_DEFINE_ENUM_ID(binarize_translate),
    S11N_DEFINE_ENUM_ID(binarize_visibility),
    S11N_DEFINE_ENUM_ID(binary_offset),
    S11N_DEFINE_ENUM_ID(bind_index),
    S11N_DEFINE_ENUM_ID(bind_size),
    S11N_DEFINE_ENUM_ID(blend_mode),
    S11N_DEFINE_ENUM_ID(block_var),
    S11N_DEFINE_ENUM_ID(block_var_array),
    S11N_DEFINE_ENUM_ID(shader_storage_block_var),
    S11N_DEFINE_ENUM_ID(shader_storage_block_var_array),
    S11N_DEFINE_ENUM_ID(bone),
    S11N_DEFINE_ENUM_ID(bone_anim),
    S11N_DEFINE_ENUM_ID(bone_anim_array),
    S11N_DEFINE_ENUM_ID(bone_anim_target),
    S11N_DEFINE_ENUM_ID(bone_array),
    S11N_DEFINE_ENUM_ID(bone_index),
    S11N_DEFINE_ENUM_ID(bone_name),
    S11N_DEFINE_ENUM_ID(bone_vis_bone_anim),
    S11N_DEFINE_ENUM_ID(bone_vis_bone_anim_array),
    S11N_DEFINE_ENUM_ID(bone_visibility_anim),
    S11N_DEFINE_ENUM_ID(bone_visibility_anim_info),
    S11N_DEFINE_ENUM_ID(branch),
    S11N_DEFINE_ENUM_ID(camera_anim),
    S11N_DEFINE_ENUM_ID(camera_anim_array),
    S11N_DEFINE_ENUM_ID(camera_anim_target),
    S11N_DEFINE_ENUM_ID(camera_name),
    S11N_DEFINE_ENUM_ID(choice),
    S11N_DEFINE_ENUM_ID(code_page),
    S11N_DEFINE_ENUM_ID(column),
    S11N_DEFINE_ENUM_ID(color_blend),
    S11N_DEFINE_ENUM_ID(comp_sel),
    S11N_DEFINE_ENUM_ID(component_index),
    S11N_DEFINE_ENUM_ID(compute_shader),
    S11N_DEFINE_ENUM_ID(compute_stage),
    S11N_DEFINE_ENUM_ID(compute_symbol),
    S11N_DEFINE_ENUM_ID(condition),
    S11N_DEFINE_ENUM_ID(config_path),
    S11N_DEFINE_ENUM_ID(const_color),
    S11N_DEFINE_ENUM_ID(converter),
    S11N_DEFINE_ENUM_ID(count),
    S11N_DEFINE_ENUM_ID(default),
    S11N_DEFINE_ENUM_ID(depend),
    S11N_DEFINE_ENUM_ID(depth),
    S11N_DEFINE_ENUM_ID(depth_test),
    S11N_DEFINE_ENUM_ID(dimension),
    S11N_DEFINE_ENUM_ID(display_face),
    S11N_DEFINE_ENUM_ID(dist_attn_func),
    S11N_DEFINE_ENUM_ID(enable),
    S11N_DEFINE_ENUM_ID(env_name),
    S11N_DEFINE_ENUM_ID(file),
    S11N_DEFINE_ENUM_ID(filter),
    S11N_DEFINE_ENUM_ID(force_include),
    S11N_DEFINE_ENUM_ID(force_include_array),
    S11N_DEFINE_ENUM_ID(force_include_file),
    S11N_DEFINE_ENUM_ID(force_include_file_array),
    S11N_DEFINE_ENUM_ID(fog_anim),
    S11N_DEFINE_ENUM_ID(fog_anim_array),
    S11N_DEFINE_ENUM_ID(fog_anim_target),
    S11N_DEFINE_ENUM_ID(fog_name),
    S11N_DEFINE_ENUM_ID(format),
    S11N_DEFINE_ENUM_ID(fragment_shader),
    S11N_DEFINE_ENUM_ID(fragment_stage),
    S11N_DEFINE_ENUM_ID(fragment_symbol),
    S11N_DEFINE_ENUM_ID(frame_count),
    S11N_DEFINE_ENUM_ID(frame_type),
    S11N_DEFINE_ENUM_ID(func),
    S11N_DEFINE_ENUM_ID(geometry_shader),
    S11N_DEFINE_ENUM_ID(geometry_stage),
    S11N_DEFINE_ENUM_ID(geometry_symbol),
    S11N_DEFINE_ENUM_ID(group),
    S11N_DEFINE_ENUM_ID(group_array),
    S11N_DEFINE_ENUM_ID(group_name),
    S11N_DEFINE_ENUM_ID(height),
    S11N_DEFINE_ENUM_ID(hermite_curve),
    S11N_DEFINE_ENUM_ID(hint),
    S11N_DEFINE_ENUM_ID(id),
    S11N_DEFINE_ENUM_ID(id_set),
    S11N_DEFINE_ENUM_ID(include_path),
    S11N_DEFINE_ENUM_ID(include_path_array),
    S11N_DEFINE_ENUM_ID(index),
    S11N_DEFINE_ENUM_ID(input),
    S11N_DEFINE_ENUM_ID(input_array),
    S11N_DEFINE_ENUM_ID(interleave),
    S11N_DEFINE_ENUM_ID(interleave_array),
    S11N_DEFINE_ENUM_ID(inv_model_matrix),
    S11N_DEFINE_ENUM_ID(key_shape),
    S11N_DEFINE_ENUM_ID(key_shape_array),
    S11N_DEFINE_ENUM_ID(key_shape_name),
    S11N_DEFINE_ENUM_ID(key_type),
    S11N_DEFINE_ENUM_ID(length),
    S11N_DEFINE_ENUM_ID(light_anim),
    S11N_DEFINE_ENUM_ID(light_anim_array),
    S11N_DEFINE_ENUM_ID(light_anim_target),
    S11N_DEFINE_ENUM_ID(light_name),
    S11N_DEFINE_ENUM_ID(linear),
    S11N_DEFINE_ENUM_ID(linear_curve),
    S11N_DEFINE_ENUM_ID(lod),
    S11N_DEFINE_ENUM_ID(lod_offset),
    S11N_DEFINE_ENUM_ID(logical_blend),
    S11N_DEFINE_ENUM_ID(loop),
    S11N_DEFINE_ENUM_ID(macro),
    S11N_DEFINE_ENUM_ID(macro_array),
    S11N_DEFINE_ENUM_ID(mag),
    S11N_DEFINE_ENUM_ID(mat_name),
    S11N_DEFINE_ENUM_ID(mat_vis_mat_anim),
    S11N_DEFINE_ENUM_ID(mat_vis_mat_anim_array),
    S11N_DEFINE_ENUM_ID(mat_visibility_anim),
    S11N_DEFINE_ENUM_ID(mat_visibility_anim_info),
    S11N_DEFINE_ENUM_ID(material),
    S11N_DEFINE_ENUM_ID(material_array),
    S11N_DEFINE_ENUM_ID(material_info),
    S11N_DEFINE_ENUM_ID(material_shader),
    S11N_DEFINE_ENUM_ID(matrix_index),
    S11N_DEFINE_ENUM_ID(max),
    S11N_DEFINE_ENUM_ID(max_aniso),
    S11N_DEFINE_ENUM_ID(mesh),
    S11N_DEFINE_ENUM_ID(mesh_adjacency),
    S11N_DEFINE_ENUM_ID(mesh_array),
    S11N_DEFINE_ENUM_ID(min),
    S11N_DEFINE_ENUM_ID(mip),
    S11N_DEFINE_ENUM_ID(mip_level),
    S11N_DEFINE_ENUM_ID(mip_offset),
    S11N_DEFINE_ENUM_ID(mode),
    S11N_DEFINE_ENUM_ID(model),
    S11N_DEFINE_ENUM_ID(model_info),
    S11N_DEFINE_ENUM_ID(motion_mirroring_enable),
    S11N_DEFINE_ENUM_ID(name),
    S11N_DEFINE_ENUM_ID(normal_matrix),
    S11N_DEFINE_ENUM_ID(nostrip),
    S11N_DEFINE_ENUM_ID(nw4f_3dif),
    S11N_DEFINE_ENUM_ID(offset),
    S11N_DEFINE_ENUM_ID(op),
    S11N_DEFINE_ENUM_ID(option),
    S11N_DEFINE_ENUM_ID(option_array),
    S11N_DEFINE_ENUM_ID(option_var),
    S11N_DEFINE_ENUM_ID(option_var_array),
    S11N_DEFINE_ENUM_ID(optional),
    S11N_DEFINE_ENUM_ID(original_material_anim),
    S11N_DEFINE_ENUM_ID(original_material_anim_array),
    S11N_DEFINE_ENUM_ID(page),
    S11N_DEFINE_ENUM_ID(page_array),
    S11N_DEFINE_ENUM_ID(page_name),
    S11N_DEFINE_ENUM_ID(path),
    S11N_DEFINE_ENUM_ID(param_anim),
    S11N_DEFINE_ENUM_ID(param_anim_array),
    S11N_DEFINE_ENUM_ID(param_anim_target),
    S11N_DEFINE_ENUM_ID(parent_index),
    S11N_DEFINE_ENUM_ID(parent_name),
    S11N_DEFINE_ENUM_ID(pattern_anim_target),
    S11N_DEFINE_ENUM_ID(pattern_index),
    S11N_DEFINE_ENUM_ID(pass_name),
    S11N_DEFINE_ENUM_ID(pitch),
    S11N_DEFINE_ENUM_ID(post_wrap),
    S11N_DEFINE_ENUM_ID(pre_wrap),
    S11N_DEFINE_ENUM_ID(projection_mode),
    S11N_DEFINE_ENUM_ID(quantize_type),
    S11N_DEFINE_ENUM_ID(render_info),
    S11N_DEFINE_ENUM_ID(render_info_array),
    S11N_DEFINE_ENUM_ID(render_info_slot),
    S11N_DEFINE_ENUM_ID(render_info_slot_array),
    S11N_DEFINE_ENUM_ID(render_state),
    S11N_DEFINE_ENUM_ID(revision),
    S11N_DEFINE_ENUM_ID(rgb_dst_func),
    S11N_DEFINE_ENUM_ID(rgb_op),
    S11N_DEFINE_ENUM_ID(rgb_src_func),
    S11N_DEFINE_ENUM_ID(rigid_body),
    S11N_DEFINE_ENUM_ID(rotate),
    S11N_DEFINE_ENUM_ID(rotate_mode),
    S11N_DEFINE_ENUM_ID(sampler),
    S11N_DEFINE_ENUM_ID(sampler_assign),
    S11N_DEFINE_ENUM_ID(sampler_assign_array),
    S11N_DEFINE_ENUM_ID(sampler_array),
    S11N_DEFINE_ENUM_ID(sampler_index),
    S11N_DEFINE_ENUM_ID(sampler_name),
    S11N_DEFINE_ENUM_ID(sampler_var),
    S11N_DEFINE_ENUM_ID(sampler_var_array),
    S11N_DEFINE_ENUM_ID(scale),
    S11N_DEFINE_ENUM_ID(scale_compensate),
    S11N_DEFINE_ENUM_ID(scale_enable),
    S11N_DEFINE_ENUM_ID(scale_mode),
    S11N_DEFINE_ENUM_ID(scene_anim),
    S11N_DEFINE_ENUM_ID(scene_anim_info),
    S11N_DEFINE_ENUM_ID(semantic_index),
    S11N_DEFINE_ENUM_ID(semantic_name),
    S11N_DEFINE_ENUM_ID(set),
    S11N_DEFINE_ENUM_ID(shader),
    S11N_DEFINE_ENUM_ID(shader_array),
    S11N_DEFINE_ENUM_ID(shader_assign),
    S11N_DEFINE_ENUM_ID(shader_archive),
    S11N_DEFINE_ENUM_ID(shader_config),
    S11N_DEFINE_ENUM_ID(shader_config_info),
    S11N_DEFINE_ENUM_ID(shader_definition),
    S11N_DEFINE_ENUM_ID(shader_definition_info),
    S11N_DEFINE_ENUM_ID(shader_option),
    S11N_DEFINE_ENUM_ID(shader_option_array),
    S11N_DEFINE_ENUM_ID(shader_param),
    S11N_DEFINE_ENUM_ID(shader_param_anim),
    S11N_DEFINE_ENUM_ID(shader_param_anim_info),
    S11N_DEFINE_ENUM_ID(shader_param_array),
    S11N_DEFINE_ENUM_ID(shader_param_mat_anim),
    S11N_DEFINE_ENUM_ID(shader_param_mat_anim_array),
    S11N_DEFINE_ENUM_ID(shader_path),
    S11N_DEFINE_ENUM_ID(shader_program),
    S11N_DEFINE_ENUM_ID(shader_program_array),
    S11N_DEFINE_ENUM_ID(shader_src),
    S11N_DEFINE_ENUM_ID(shader_src_array),
    S11N_DEFINE_ENUM_ID(shader_stage),
    S11N_DEFINE_ENUM_ID(shader_symbol),
    S11N_DEFINE_ENUM_ID(shader_variation),
    S11N_DEFINE_ENUM_ID(shader_variation_info),
    S11N_DEFINE_ENUM_ID(shading_model),
    S11N_DEFINE_ENUM_ID(shading_model_array),
    S11N_DEFINE_ENUM_ID(shading_model_name),
    S11N_DEFINE_ENUM_ID(shape),
    S11N_DEFINE_ENUM_ID(shape_anim),
    S11N_DEFINE_ENUM_ID(shape_anim_info),
    S11N_DEFINE_ENUM_ID(shape_anim_target),
    S11N_DEFINE_ENUM_ID(shape_array),
    S11N_DEFINE_ENUM_ID(shape_info),
    S11N_DEFINE_ENUM_ID(shape_name),
    S11N_DEFINE_ENUM_ID(shape_shader_assign),
    S11N_DEFINE_ENUM_ID(side),
    S11N_DEFINE_ENUM_ID(size),
    S11N_DEFINE_ENUM_ID(skeletal_anim),
    S11N_DEFINE_ENUM_ID(skeletal_anim_info),
    S11N_DEFINE_ENUM_ID(skeleton),
    S11N_DEFINE_ENUM_ID(skeleton_info),
    S11N_DEFINE_ENUM_ID(smooth_skinning),
    S11N_DEFINE_ENUM_ID(step_curve),
    S11N_DEFINE_ENUM_ID(stream),
    S11N_DEFINE_ENUM_ID(stream_array),
    S11N_DEFINE_ENUM_ID(stream_index),
    S11N_DEFINE_ENUM_ID(streamout),
    S11N_DEFINE_ENUM_ID(streamout_array),
    S11N_DEFINE_ENUM_ID(string),
    S11N_DEFINE_ENUM_ID(src_index),
    S11N_DEFINE_ENUM_ID(src_type),
    S11N_DEFINE_ENUM_ID(submesh),
    S11N_DEFINE_ENUM_ID(submesh_array),
    S11N_DEFINE_ENUM_ID(submesh_index),
    S11N_DEFINE_ENUM_ID(swizzle),
    S11N_DEFINE_ENUM_ID(target),
    S11N_DEFINE_ENUM_ID(target_attrib),
    S11N_DEFINE_ENUM_ID(target_attrib_array),
    S11N_DEFINE_ENUM_ID(target_shader),
    S11N_DEFINE_ENUM_ID(target_shader_array),
    S11N_DEFINE_ENUM_ID(tex_name),
    S11N_DEFINE_ENUM_ID(tex_pattern),
    S11N_DEFINE_ENUM_ID(tex_pattern_array),
    S11N_DEFINE_ENUM_ID(tex_pattern_anim),
    S11N_DEFINE_ENUM_ID(tex_pattern_anim_info),
    S11N_DEFINE_ENUM_ID(tex_pattern_mat_anim),
    S11N_DEFINE_ENUM_ID(tex_pattern_mat_anim_array),
    S11N_DEFINE_ENUM_ID(text),
    S11N_DEFINE_ENUM_ID(textblock),
    S11N_DEFINE_ENUM_ID(textblock_array),
    S11N_DEFINE_ENUM_ID(texture),
    S11N_DEFINE_ENUM_ID(texture_info),
    S11N_DEFINE_ENUM_ID(tile_mode),
    S11N_DEFINE_ENUM_ID(tool_data),
    S11N_DEFINE_ENUM_ID(translate),
    S11N_DEFINE_ENUM_ID(type),
    S11N_DEFINE_ENUM_ID(u),
    S11N_DEFINE_ENUM_ID(ui_alias),
    S11N_DEFINE_ENUM_ID(ui_anim_editable),
    S11N_DEFINE_ENUM_ID(ui_comment),
    S11N_DEFINE_ENUM_ID(ui_default_max),
    S11N_DEFINE_ENUM_ID(ui_default_min),
    S11N_DEFINE_ENUM_ID(ui_editable),
    S11N_DEFINE_ENUM_ID(ui_group),
    S11N_DEFINE_ENUM_ID(ui_item),
    S11N_DEFINE_ENUM_ID(ui_max),
    S11N_DEFINE_ENUM_ID(ui_min),
    S11N_DEFINE_ENUM_ID(ui_label),
    S11N_DEFINE_ENUM_ID(ui_order),
    S11N_DEFINE_ENUM_ID(ui_visible),
    S11N_DEFINE_ENUM_ID(uniform_var),
    S11N_DEFINE_ENUM_ID(uniform_var_array),
    S11N_DEFINE_ENUM_ID(buffer_var),
    S11N_DEFINE_ENUM_ID(buffer_var_array),
    S11N_DEFINE_ENUM_ID(unite_pos_quantize),
    S11N_DEFINE_ENUM_ID(user_data),
    S11N_DEFINE_ENUM_ID(user_data_array),
    S11N_DEFINE_ENUM_ID(user_float),
    S11N_DEFINE_ENUM_ID(user_int),
    S11N_DEFINE_ENUM_ID(user_stream),
    S11N_DEFINE_ENUM_ID(user_string),
    S11N_DEFINE_ENUM_ID(user_wstring),
    S11N_DEFINE_ENUM_ID(v),
    S11N_DEFINE_ENUM_ID(value),
    S11N_DEFINE_ENUM_ID(variation),
    S11N_DEFINE_ENUM_ID(variation_array),
    S11N_DEFINE_ENUM_ID(varying),
    S11N_DEFINE_ENUM_ID(version),
    S11N_DEFINE_ENUM_ID(vertex),
    S11N_DEFINE_ENUM_ID(vertex_array),
    S11N_DEFINE_ENUM_ID(vertex_index),
    S11N_DEFINE_ENUM_ID(vertex_shader),
    S11N_DEFINE_ENUM_ID(vertex_shape_anim),
    S11N_DEFINE_ENUM_ID(vertex_shape_anim_array),
    S11N_DEFINE_ENUM_ID(vertex_skinning_count),
    S11N_DEFINE_ENUM_ID(vertex_stage),
    S11N_DEFINE_ENUM_ID(vertex_symbol),
    S11N_DEFINE_ENUM_ID(visibility),
    S11N_DEFINE_ENUM_ID(vtx_attrib),
    S11N_DEFINE_ENUM_ID(vtx_attrib_array),
    S11N_DEFINE_ENUM_ID(vtx_buffer),
    S11N_DEFINE_ENUM_ID(vtx_buffer_array),
    S11N_DEFINE_ENUM_ID(w),
    S11N_DEFINE_ENUM_ID(width),
    S11N_DEFINE_ENUM_ID(wrap),
    S11N_DEFINE_ENUM_ID(write),
    S11N_DEFINE_ENUM_ID(wstring),
    S11N_DEFINE_ENUM_ID(pattern_anim),
    S11N_DEFINE_ENUM_ID(tex_pattern_anim_array),		//!< tex_pattern_anim の配列の時の要素名です。050 では *_array の命名規則に従っていません。
    S11N_DEFINE_ENUM_ID(material_visibility_anim),
    S11N_DEFINE_ENUM_ID(param_anim),
    S11N_DEFINE_ENUM_ID(shader_param_anim_array),//!< param_anim の配列のときの要素名。050 では *_array の命名規則に従っていません。
    S11N_DEFINE_ENUM_ID(material_anim),
    S11N_DEFINE_ENUM_ID(material_anim_info),
    S11N_DEFINE_ENUM_ID(per_material_anim),
    S11N_DEFINE_ENUM_ID(per_material_anim_array),
    S11N_DEFINE_ENUM_ID(original_per_material_anim),
    S11N_DEFINE_ENUM_ID(original_per_material_anim_array),
};
static_assert(sizeof(tbl_identifier) == sizeof(util::LiteralStr) * num_identifier,
    "Invalid table size.");

inline
const char* GetIdentifierName( Identifier id )
{
    return tbl_identifier[id].str;
}

} // namespace g3dif

} // namespace tool
} // namespace g3d
} // namespace nw
