﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <g3dif/Serialization.h>

namespace nw { namespace g3d { namespace tool {
namespace g3dif {

struct DataStream
{
    std::shared_ptr<void> rawdata;
    StreamType type;
    int count;
};

// バイナリデータを解析します。
void AnalizeBinaryData(StreamArray& streamArray, void* data);
// コピーしたメモリを返します。
void* CopyRawData(StreamChunk& streamChunk);

class elem_stream
{
public:
    G3DIF_DEFINE_ENUM(type,
        type_float,
        type_int,
        type_byte,
        type_string,
        type_wstring
        );

    elem_stream() : type(type_float), count(), column(10), textData(NULL) {}

    G3DIF_DEFINE_ELEM_ARRAY(stream);

    G3DIF_DEFINE_ATTRIB(enum_type, type);
    G3DIF_DEFINE_ATTRIB(int, count);
    G3DIF_DEFINE_ATTRIB(int, column);

    StreamType GetStreamType() const
    {
        if (type.value == type_float)
        {
            return StreamTypeFloat;
        }
        else if (type.value == type_int)
        {
            return StreamTypeInt;
        }
        else if (type.value == type_byte)
        {
            return StreamTypeByte;
        }
        else if (type.value == type_string)
        {
            return StreamTypeString;
        }
        else if (type.value == type_wstring)
        {
            return StreamTypeWString;
        }
        else
        {
            return StreamTypeByte;
        }
    }

    const char* textData;
};

} // namespace g3dif

} // namespace tool
} // namespace g3d
} // namespace nw
