﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <g3dif/Serialization.h>
#include <g3dif/Skeleton.h>
#include <g3dif/AnimCurve.h>
#include <g3dif/UserData.h>
#include <g3dif/Stream.h>

namespace nw { namespace g3d { namespace tool {
namespace g3dif {

class elem_bone_anim_target
{
public:
    G3DIF_DEFINE_ENUM(target,
        scale_x,
        scale_y,
        scale_z,
        rotate_x,
        rotate_y,
        rotate_z,
        rotate_w,
        translate_x,
        translate_y,
        translate_z
    );

    elem_bone_anim_target()
        : target(scale_x)
        , base_value(0.0f)
        , curve()
    {
    }

    G3DIF_DEFINE_ELEM(bone_anim_target);

    G3DIF_DEFINE_ATTRIB(enum_target, target);
    G3DIF_DEFINE_ATTRIB(float, base_value);

    util::Optional<elem_anim_curve> curve;
};

class elem_bone_anim
{
public:

    elem_bone_anim()
        : bind_index(-1)
        , bone_name()
        , parent_name()
        , scale_compensate(false)
        , binarize_scale(true)
        , binarize_rotate(true)
        , binarize_translate(true)
        , bone_anim_target_array()
    {
    }

    G3DIF_DEFINE_ELEM_ARRAY(bone_anim);

    G3DIF_DEFINE_ATTRIB(int, bind_index);
    G3DIF_DEFINE_ATTRIB(std::string, bone_name);
    G3DIF_DEFINE_ATTRIB(std::string, parent_name);
    G3DIF_DEFINE_ATTRIB(bool, scale_compensate);
    G3DIF_DEFINE_ATTRIB(bool, binarize_scale);
    G3DIF_DEFINE_ATTRIB(bool, binarize_rotate);
    G3DIF_DEFINE_ATTRIB(bool, binarize_translate);

    std::vector<elem_bone_anim_target> bone_anim_target_array;
};

class elem_skeletal_anim_info
{
public:

    elem_skeletal_anim_info()
        : frame_count(0)
        , loop(true)
        , scale_mode(elem_skeleton_info::standard)
        , rotate_mode(elem_skeleton_info::euler_xyz)
    {
    }

    G3DIF_DEFINE_ELEM(skeletal_anim_info);

    G3DIF_DEFINE_ATTRIB(int, frame_count);
    G3DIF_DEFINE_ATTRIB(bool, loop);
    G3DIF_DEFINE_ATTRIB(elem_skeleton_info::enum_scale_mode, scale_mode);
    G3DIF_DEFINE_ATTRIB(elem_skeleton_info::enum_rotate_mode, rotate_mode);
};

class elem_skeletal_anim
{
public:

    elem_skeletal_anim()
        : name()
        , path()
        , skeletal_anim_info()
        , bone_anim_array()
        , stream_array()
        , user_data_array()
    {
    }

    G3DIF_DEFINE_ELEM(skeletal_anim);

    G3DIF_DEFINE_ATTRIB(Version, version);

    void PostProcess();
    void PostBinaryProcess(void* data);
    void SetName(const char* fileName) { this->name.assign(fileName); }
    void SetPath(const char* filePath) { this->path.assign(filePath); }

    void AdjustZeroScale();

    //! 読み込んだデータの整合性を確認します。
    void CheckData(int flag);

    std::string name;
    std::string path;

    elem_skeletal_anim_info skeletal_anim_info;
    std::vector<elem_bone_anim> bone_anim_array;
    std::vector<elem_stream> stream_array;
    std::vector<elem_user_data> user_data_array;
};

} // namespace g3dif

} // namespace tool
} // namespace g3d
} // namespace nw
