﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <g3dif/Serialization.h>
#include <g3dif/AnimCurve.h>
#include <g3dif/UserData.h>
#include <g3dif/Stream.h>
#include <g3dif/Material.h>

namespace nw { namespace g3d { namespace tool {
namespace g3dif {

class elem_param_anim_target
{
public:
    elem_param_anim_target()
        : component_index(0)
        , base_value(0.0f)
        , curve()
    {
    }

    G3DIF_DEFINE_ELEM(param_anim_target);

    G3DIF_DEFINE_ATTRIB(int, component_index);
    G3DIF_DEFINE_ATTRIB(float, base_value);

    util::Optional<elem_anim_curve> curve;
};

class elem_param_anim
{
public:

    elem_param_anim()
        : id()
        , type(elem_shader_param::type_float4)
    {
    }

    template<typename T>
    elem_param_anim& operator=(const T& rhs)
    {
        id = rhs.id;
        type = rhs.type;

        param_anim_target_array.resize( rhs.param_anim_target_array.size() );
        int idxElem = 0;
        for( auto& elemNnParamAnimTarget : rhs.param_anim_target_array )
        {
            param_anim_target_array[idxElem] = elemNnParamAnimTarget;	// 同型でメンバにポインタを含まないのでデフォルトの operator= を呼ぶ
            ++idxElem;
        }
        return *this;
    }

    G3DIF_DEFINE_ELEM_ARRAY(param_anim);

    G3DIF_DEFINE_ATTRIB(std::string, id);
    G3DIF_DEFINE_ATTRIB(elem_shader_param::enum_type, type);

    std::vector<elem_param_anim_target> param_anim_target_array;
};


class elem_shader_param_mat_anim
{
public:
    elem_shader_param_mat_anim()
        : mat_name()
    {
    }

    template<typename T>
    elem_shader_param_mat_anim& operator=(const T& rhs)
    {
        // nw fma 互換では fma の中に shader param と material visi の共存を許可しない
        if( rhs.material_visibility_anim )
        {
            THROW_ERROR(ERRCODE_INVALID_MATERIAL_ANIM_FILE_TYPE, "Invalid material anim. Material \"%s\" has both shader param and material visibility anim.\n");
        }

        mat_name = rhs.mat_name;
        if( rhs.shader_param_anim_array )
        {
            param_anim_array.resize( rhs.shader_param_anim_array.Get().size() );
            int idxElem = 0;
            for( auto& rhsShaderParamAnim : rhs.shader_param_anim_array.Get() )
            {
                param_anim_array[idxElem] = rhsShaderParamAnim;
                ++idxElem;
            }
        }

        return *this;
    }

    G3DIF_DEFINE_ELEM_ARRAY(shader_param_mat_anim);

    G3DIF_DEFINE_ATTRIB(std::string, mat_name);

    std::vector<elem_param_anim> param_anim_array;
};

class elem_original_material_anim
{
public:
    elem_original_material_anim()
        : mat_name()
    {
    }

    template<typename T>
    elem_original_material_anim& operator=(const T& rhs)
    {
        mat_name = rhs.mat_name;
        return *this;
    }

    G3DIF_DEFINE_ELEM_ARRAY(original_material_anim);

    G3DIF_DEFINE_ATTRIB(std::string, mat_name);
};

class elem_shader_param_anim_info
{
public:

    elem_shader_param_anim_info()
        : frame_count(0)
        , loop(true)
    {
    }

    template<typename T>
    elem_shader_param_anim_info& operator=(const T& rhs)
    {
        frame_count = rhs.frame_count;
        loop = rhs.loop;
        return *this;
    }

    G3DIF_DEFINE_ELEM(shader_param_anim_info);

    G3DIF_DEFINE_ATTRIB(int, frame_count);
    G3DIF_DEFINE_ATTRIB(bool, loop);
};

class elem_shader_param_anim
{
public:

    elem_shader_param_anim()
        : name()
        , path()
        , shader_param_anim_info()
        , shader_param_mat_anim_array()
        , user_data_array()
    {
    }

    template<typename T>
    elem_shader_param_anim& operator=(const T& rhs)
    {
        // shader param info
    	shader_param_anim_info = rhs.material_anim_info;

        // shader_param_mat_anim_array
        shader_param_mat_anim_array.resize( rhs.per_material_anim_array.size() );
        int idxElem = 0;
        for( auto& elemNnPerMatAnim : rhs.per_material_anim_array )
        {
            shader_param_mat_anim_array[idxElem] = elemNnPerMatAnim;
            ++idxElem;
        }

        // original_material_anim_array
        original_material_anim_array.resize( rhs.original_per_mterial_anim_array.size() );
        idxElem = 0;
        for( auto& elemNnPerMatAnim : rhs.original_per_mterial_anim_array )
        {
            original_material_anim_array[idxElem] = elemNnPerMatAnim;
            ++idxElem;
        }

        // stream_array
        stream_array.resize( rhs.stream_array.size() );
        idxElem = 0;
        for( auto& elemNnPerMatAnim : rhs.stream_array )
        {
            stream_array[idxElem] = elemNnPerMatAnim;	// 同型でメンバにポインタを含まないのでデフォルトの operator= を呼ぶ
            ++idxElem;
        }

        // user_data_array
        user_data_array.resize( rhs.user_data_array.size() );
        idxElem = 0;
        for( auto& elemNnPerMatAnim : rhs.user_data_array )
        {
            user_data_array[idxElem] = elemNnPerMatAnim;	// 同型でメンバにポインタを含まないのでデフォルトの operator= を呼ぶ
            ++idxElem;
        }

    	return *this;
    }

    G3DIF_DEFINE_ELEM(shader_param_anim);

    G3DIF_DEFINE_ATTRIB(Version, version);

    void PostProcess();
    void PostBinaryProcess(void* data);
    void SetName(const char* fileName) { this->name.assign(fileName); }
    void SetPath(const char* filePath) { this->path.assign(filePath); }

    //! 読み込んだデータの整合性を確認します。
    void CheckData(int flag);

    std::string name;
    std::string path;

    elem_shader_param_anim_info shader_param_anim_info;
    std::vector<elem_shader_param_mat_anim> shader_param_mat_anim_array;
    std::vector<elem_original_material_anim> original_material_anim_array;
    std::vector<elem_stream> stream_array;
    std::vector<elem_user_data> user_data_array;
};

} // namespace g3dif

} // namespace tool
} // namespace g3d
} // namespace nw
