﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <g3dif/Serialization.h>
#include <g3dif/AnimCurve.h>
#include <g3dif/UserData.h>
#include <g3dif/Stream.h>

namespace nw { namespace g3d { namespace tool {
namespace g3dif {

class elem_camera_anim_target
{
public:
    G3DIF_DEFINE_ENUM(target,
        target_position_x,
        target_position_y,
        target_position_z,
        target_aim_x,
        target_aim_y,
        target_aim_z,
        target_twist,
        target_rotate_x,
        target_rotate_y,
        target_rotate_z,
        target_aspect,
        target_near,
        target_far,
        target_ortho_height,
        target_persp_fovy
        );

    elem_camera_anim_target()
        : target()
        , base_value(0.0f)
        , curve()
    {
    }

    G3DIF_DEFINE_ELEM(camera_anim_target);

    G3DIF_DEFINE_ATTRIB(enum_target, target);
    G3DIF_DEFINE_ATTRIB(float, base_value);

    util::Optional<elem_anim_curve> curve;
};

class elem_camera_anim
{
public:
    G3DIF_DEFINE_ENUM(rotate_mode,
        aim,
        euler_zxy
        );

    G3DIF_DEFINE_ENUM(projection_mode,
        ortho,
        persp
        );

    elem_camera_anim()
        : camera_name()
        , frame_count(0)
        , loop(false)
        , rotate_mode(aim)
        , projection_mode(ortho)
        , camera_anim_target_array()
        , user_data_array()
    {
    }

    G3DIF_DEFINE_ELEM_ARRAY(camera_anim);

    G3DIF_DEFINE_ATTRIB(std::string, camera_name);
    G3DIF_DEFINE_ATTRIB(int, frame_count);
    G3DIF_DEFINE_ATTRIB(bool, loop);
    G3DIF_DEFINE_ATTRIB(enum_rotate_mode, rotate_mode);
    G3DIF_DEFINE_ATTRIB(enum_projection_mode, projection_mode);

    std::vector<elem_camera_anim_target> camera_anim_target_array;
    std::vector<elem_user_data> user_data_array;
};

class elem_light_anim_target
{
public:
    G3DIF_DEFINE_ENUM(target,
        target_enable,
        target_position_x,
        target_position_y,
        target_position_z,
        target_direction_x,
        target_direction_y,
        target_direction_z,
        target_aim_x,
        target_aim_y,
        target_aim_z,
        target_dist_attn_start,
        target_dist_attn_end,
        target_angle_attn_start,
        target_angle_attn_end,
        target_color0_r,
        target_color0_g,
        target_color0_b,
        target_color1_r,
        target_color1_g,
        target_color1_b
        );

    elem_light_anim_target()
        : target(target_enable)
        , base_value(0.0f)
        , curve()
    {
    }

    G3DIF_DEFINE_ELEM(light_anim_target);

    G3DIF_DEFINE_ATTRIB(enum_target, target);
    G3DIF_DEFINE_ATTRIB(float, base_value);

    util::Optional<elem_anim_curve> curve;
};

class elem_light_anim
{
public:
    elem_light_anim()
        : light_name()
        , frame_count(0)
        , loop(false)
        , type()
        , dist_attn_func()
        , angle_attn_func()
        , light_anim_target_array()
        , user_data_array()
    {
    }

    G3DIF_DEFINE_ELEM_ARRAY(light_anim);

    G3DIF_DEFINE_ATTRIB(std::string, light_name);
    G3DIF_DEFINE_ATTRIB(int, frame_count);
    G3DIF_DEFINE_ATTRIB(bool, loop);
    G3DIF_DEFINE_ATTRIB(std::string, type);
    G3DIF_DEFINE_ATTRIB(std::string, dist_attn_func);
    G3DIF_DEFINE_ATTRIB(std::string, angle_attn_func);

    std::vector<elem_light_anim_target> light_anim_target_array;
    std::vector<elem_user_data> user_data_array;
};

class elem_fog_anim_target
{
public:
    G3DIF_DEFINE_ENUM(target,
        target_dist_attn_start,
        target_dist_attn_end,
        target_color_r,
        target_color_g,
        target_color_b
        );

    elem_fog_anim_target()
        : target(target_dist_attn_start)
        , base_value(0.0f)
        , curve()
    {
    }

    G3DIF_DEFINE_ELEM(fog_anim_target);

    G3DIF_DEFINE_ATTRIB(enum_target, target);
    G3DIF_DEFINE_ATTRIB(float, base_value);

    util::Optional<elem_anim_curve> curve;
};

class elem_fog_anim
{
public:
    elem_fog_anim()
        : fog_name()
        , frame_count(0)
        , loop(false)
        , dist_attn_func()
        , fog_anim_target_array()
        , user_data_array()
    {
    }

    G3DIF_DEFINE_ELEM_ARRAY(fog_anim);

    G3DIF_DEFINE_ATTRIB(std::string, fog_name);
    G3DIF_DEFINE_ATTRIB(int, frame_count);
    G3DIF_DEFINE_ATTRIB(bool, loop);
    G3DIF_DEFINE_ATTRIB(std::string, dist_attn_func);

    std::vector<elem_fog_anim_target> fog_anim_target_array;
    std::vector<elem_user_data> user_data_array;
};

class elem_scene_anim_info
{
public:
    elem_scene_anim_info() {}

    G3DIF_DEFINE_ELEM(scene_anim_info);
};

class elem_scene_anim
{
public:
    elem_scene_anim()
        : name()
        , path()
        , scene_anim_info()
        , camera_anim_array()
        , light_anim_array()
        , fog_anim_array()
        , stream_array()
        , user_data_array()
    {
    }

    G3DIF_DEFINE_ELEM(scene_anim);

    G3DIF_DEFINE_ATTRIB(Version, version);

    void PostProcess();
    void PostBinaryProcess(void* data);
    void SetName(const char* fileName) { this->name.assign(fileName); }
    void SetPath(const char* filePath) { this->path.assign(filePath); }

    //! 読み込んだデータの整合性を確認します。
    void CheckData(int flag);

    std::string name;
    std::string path;

    elem_scene_anim_info scene_anim_info;
    std::vector<elem_camera_anim> camera_anim_array;
    std::vector<elem_light_anim> light_anim_array;
    std::vector<elem_fog_anim> fog_anim_array;
    std::vector<elem_stream> stream_array;
    std::vector<elem_user_data> user_data_array;
};

} // namespace g3dif

} // namespace tool
} // namespace g3d
} // namespace nw
