﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <g3dif/Serialization.h>
#include <g3dif/Skeleton.h>
#include <g3dif/Shape.h>
#include <g3dif/Material.h>
#include <g3dif/UserData.h>
#include <g3dif/ToolData.h>
#include <g3dif/Stream.h>

namespace nw { namespace g3d { namespace tool {
namespace g3dif {

//--------------------------------------------------------------------------------------------------

class elem_model_info
{
public:
    elem_model_info()
        : unite_pos_quantize()
    {
    }

    G3DIF_DEFINE_ELEM(model_info);

    G3DIF_DEFINE_ATTRIB(bool, unite_pos_quantize);
};

class elem_model
{
public:
    elem_model()
        : name()
        , path()
        , model_info()
        , skeleton()
        , shape_array()
        , material_array()
        , stream_array()
        , user_data_array()
        , tool_data()
    {
    }

    G3DIF_DEFINE_ELEM(model);

    G3DIF_DEFINE_ATTRIB(Version, version);

    void PostProcess();
    void PostBinaryProcess(void* data);
    void SetName(const char* fileName) { this->name.assign(fileName); };
    void SetPath(const char* filePath) { this->path.assign(filePath); }

    //! 読み込んだデータの整合性を確認します。
    void CheckData(int flag);

    std::string name;
    std::string path;

    elem_model_info model_info;
    util::Optional<elem_skeleton> skeleton;
    std::vector<elem_vertex> vertex_array;
    std::vector<elem_shape> shape_array;
    std::vector<elem_material> material_array;
    std::vector<elem_stream> stream_array;
    std::vector<elem_user_data> user_data_array;
    util::Optional<elem_tool_data> tool_data;

private:
    void ResolveVertexAttrib();
    void ResolveShapeAttrib();
    void ResolvePosition();
    void ResolveBoneIndex();
    void ResolveShapeMaterial();
    void ResolveSamplerIndex();
    void ResolveUniteQuantizeType();
};

} // namespace g3dif

} // namespace tool
} // namespace g3d
} // namespace nw
