﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <g3dif/Serialization.h>
#include <g3dif/Stream.h>

namespace nw { namespace g3d { namespace tool {
namespace g3dif {

struct elem_anim_curve
{
    enum enum_curve_type
    {
        hermite,
        linear,
        step,
        num_curve_type
    };

    G3DIF_DEFINE_ENUM(frame_type,
        frame_none,
        frame32,
        frame16,
        frame8
    );

    G3DIF_DEFINE_ENUM(key_type,
        key_none,
        key32,
        key16,
        key8,
        key1
    );

    G3DIF_DEFINE_ENUM(wrap,
        clamp,
        repeat,
        mirror,
        relative_repeat
    );

    elem_anim_curve()
        : curve_type(hermite)
        , count(0)
        , frame_type(frame_none)
        , key_type(key_none)
        , pre_wrap(clamp)
        , post_wrap(clamp)
        , stream_index(-1)
        , stream()
    {
    }

    bool Read(const util::XMLElement* pParent);

    enum_curve_type curve_type;

    G3DIF_DEFINE_ATTRIB(int, count);
    G3DIF_DEFINE_ATTRIB(elem_anim_curve::enum_frame_type, frame_type);
    G3DIF_DEFINE_ATTRIB(elem_anim_curve::enum_key_type, key_type);
    G3DIF_DEFINE_ATTRIB(float, scale);
    G3DIF_DEFINE_ATTRIB(float, offset);
    G3DIF_DEFINE_ATTRIB(elem_anim_curve::enum_wrap, pre_wrap);
    G3DIF_DEFINE_ATTRIB(elem_anim_curve::enum_wrap, post_wrap);
    G3DIF_DEFINE_ATTRIB(int, stream_index);

    DataStream stream; // 参照解決後に利用可。
};

} // namespace g3dif

} // namespace tool
} // namespace g3d
} // namespace nw
