﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;

namespace nw.g3d.toollib
{
    // ファイルオプション
    public class FileOption
    {
        // コンストラクタ
        public FileOption(string path)
        {
            _path = path;
        }

        // オプションの取得
        public ArgumentOption GetOption(string optionName)
        {
            return this.Options.Find(
                delegate(ArgumentOption mutch) { return (mutch.Name == optionName); });
        }

        // オプションの有無
        public bool HasOption(string optionName)
        {
            return (GetOption(optionName) != null);
        }

        // パス
        public string Path { get { return _path; } }

        // オプション
        public List<ArgumentOption> Options { get { return _options; } }

        private readonly string _path;
        private List<ArgumentOption> _options = new List<ArgumentOption>();
    }
}
