﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// G3dTexConverter

//=============================================================================
// include
//=============================================================================
#include "Convert.h"

using namespace std;

//=============================================================================
// texcvtr ネームスペースを開始します。
//=============================================================================
namespace nn {
namespace gfx {
namespace tool {
namespace texcvtr {

//-----------------------------------------------------------------------------
// 無名名前空間を開始します。
namespace
{

const int VersionMajor  = 4; //!< コンバーターのメジャーバージョンです。
const int VersionMinor  = 4; //!< コンバーターのマイナーバージョンです。
const int VersionMicro  = 0; //!< コンバーターのマイクロバージョンです。
const int VersionBugfix = 0; //!< コンバーターのバグフィックスバージョンです。

const bool SupportsFtx = true; //!< ftx ファイルに対応するなら true です。

//-----------------------------------------------------------------------------
// 無名名前空間を終了します。
} // unnamed namespace

//-----------------------------------------------------------------------------
//! @brief 3D テクスチャーコンバーターのコンストラクターです。
//-----------------------------------------------------------------------------
G3dTexConverter::G3dTexConverter(HINSTANCE hDll)
:   TexConverterBase(hDll, VersionMajor, VersionMinor, VersionMicro, VersionBugfix, SupportsFtx)
{
    //cerr << "G3dTexConverter()" << endl;

    //-----------------------------------------------------------------------------
    // ftx ファイルに出力するツール名を設定します。
    m_ToolName = m_DefaultToolName = "3dTextureConverter";

    //-----------------------------------------------------------------------------
    // 各 DLL ファイルのパスを設定します。
    const std::string g3dToolsPath = RGetFolderFromFilePath(RGetModuleFileName(hDll)) + "\\";
    const std::string graphicsToolsPath = RGetFullFilePath(g3dToolsPath + "..\\GraphicsTools", false) + "\\";
    m_Encoder.SetDllPath((graphicsToolsPath + "TextureConverterEncoder.dll").c_str());
    m_OpenExr.SetDllPath((graphicsToolsPath + "TextureConverterOpenExr.dll").c_str());
    m_NXUtility.SetDllPath((graphicsToolsPath + "TextureConverterNX.dll").c_str());
}

//-----------------------------------------------------------------------------
//! @brief 3D テクスチャーコンバーターのデストラクターです。
//-----------------------------------------------------------------------------
G3dTexConverter::~G3dTexConverter()
{
    //cerr << "~G3dTexConverter()" << endl;
}

//=============================================================================
// texcvtr ネームスペースを終了します。
//=============================================================================
} // texcvtr
} // tool
} // gfx
} // nn

