﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cassert>
#include <map>
#include <iomanip>
#include <util/types.h>
#include <util/UtilError.h>
#include <util/UtilErrorCode.h>

#include <ShaderConverterEnum.h>

#define NN_GFX_TOOL_ENDIAN_SWAP_IS_NOT_IMPLEMENTED

#define NN_G3D_SHADER_CVTR_VERSION_MAJOR            ( 4 )
#define NN_G3D_SHADER_CVTR_VERSION_MINOR            ( 4 )
#define NN_G3D_SHADER_CVTR_VERSION_MICRO            ( 0 )

#define NN_G3D_SHADER_CVTR_VERSION									\
    NN_UTIL_CREATE_SIGNATURE_4( NN_G3D_SHADER_CVTR_VERSION_MAJOR,	\
                                NN_G3D_SHADER_CVTR_VERSION_MINOR,	\
                                NN_G3D_SHADER_CVTR_VERSION_MICRO,	\
                                0 );

namespace nn { namespace g3dTool {

enum ConvertMode
{
    ConvertMode_FscToFsd = 0x0,
    ConvertMode_FsdToBfsha = 0x1,
    ConvertMode_MergeBfsha = 0x2,
    ConvertMode_None = 0x3
};

using nw::g3d::tool::util::s8;
using nw::g3d::tool::util::s16;
using nw::g3d::tool::util::s32;
using nw::g3d::tool::util::s64;

using nw::g3d::tool::util::u8;
using nw::g3d::tool::util::u16;
using nw::g3d::tool::util::u32;
using nw::g3d::tool::util::u64;

using nw::g3d::tool::util::bit8;
using nw::g3d::tool::util::bit16;
using nw::g3d::tool::util::bit32;
using nw::g3d::tool::util::bit64;

using nw::g3d::tool::util::uint;
using nw::g3d::tool::util::char16;

// file_path, <index, file_content>
// unorderd_map だと順序が保証されないため map を使用。
typedef std::map<std::string, std::pair<int, std::string>> FileDB;

using namespace nw::g3d;
using namespace nw::g3d::tool::util;

inline std::string ShaderKeyToString(const void* pKey, size_t keyLength)
{
    std::stringstream ss;
    for (size_t idxKey = 0; idxKey < keyLength; ++idxKey)
    {
        ss << (idxKey > 0 ? "_" : "" ) << std::hex << std::setw(8) <<
            std::setfill('0') << *(static_cast<const u32*>(pKey) + idxKey);
    }
    return ss.str();
}

} // namespace g3dTool
} // namespace nn

