﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/g3d_ResShader.h>
#include <g3dif/ShaderDefinition.h>
#include <shdrdefs.h>
#include <BinaryBlock.h>

namespace nn { namespace g3dTool {

class BinShader;

//! @brief シェーダープログラムのバイナリ化を行うクラスです。
class BinProgram : public BinaryBlock
{
public:
    BinProgram()
        : BinaryBlock()
        , m_pProgram(nullptr)
        , m_pShadingModel(nullptr)
    {
    }

    void Build(std::shared_ptr<Context> pCtx, const ShaderProgram* program);
    virtual void CalculateSize();
    virtual void Convert( std::shared_ptr<Context> pCtx );
    virtual void Adjust( std::shared_ptr<Context> pCtx );
    const ShaderProgram* GetShaderProgram() const { return m_pProgram; }

    void SetShadingModel(const BinShader* pShadingModel) { m_pShadingModel = pShadingModel; }

private:
    const ShaderProgram* m_pProgram;

    const BinShader* m_pShadingModel;

    enum
    {
        SAMPLER_TABLE,
        UNIFORM_BLOCK_TABLE,
        SHADER_STORAGE_BLOCK_TABLE,
        NUM_CHUNK
    };

    Chunk m_Chunk[NUM_CHUNK];
};

} // namespace g3dTool
} // namespace nn
