﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <BinaryBlock.h>
#include <nn/util/util_ResDic.h>

namespace nn {
namespace g3dTool {

class BinDictionary : public BinaryBlock
{
public:
    BinDictionary()
        : BinaryBlock()
        , m_NameArray()
    {
    }

    void Build(std::shared_ptr<Context> pCtx, size_t dicSize);
    virtual void CalculateSize();
    virtual void Convert( std::shared_ptr<Context> pCtx );

    void SetName(int index, const std::string& name)
    {
        m_NameArray[index] = &name;
    }

    void ConvertData(std::shared_ptr<Context> pCtx, nn::util::BinTPtr<nn::util::ResDic>& ofsDic)
    {
        nn::util::ResDicData* pDic = GetPtr<nn::util::ResDicData>( pCtx->GetMemBlockPtr( Context::MemBlockType_Main ) );
        pCtx->LinkPtr( &ofsDic, pDic );
    }

    template <typename T>
    void ConvertData(std::shared_ptr<Context> pCtx, nn::util::BinTPtr<nn::util::ResDic>& ofsDic, const std::vector<T>& dataArray)
    {
        NN_UNUSED( dataArray );
        nn::util::ResDicData* pDic = GetPtr<nn::util::ResDicData>( pCtx->GetMemBlockPtr( Context::MemBlockType_Main ) );
        pCtx->LinkPtr( &ofsDic, pDic );
    }

    template <typename T>
    void ConvertArrayData(std::shared_ptr<Context> pCtx, nn::util::BinTPtr<nn::util::ResDic>& ofsDic, T* pData, int count)
    {
        NN_UNUSED( pData );
        NN_UNUSED( count );
        nn::util::ResDicData* pDic = GetPtr<nn::util::ResDicData>( pCtx->GetMemBlockPtr( Context::MemBlockType_Main ) );
        pCtx->LinkPtr( &ofsDic, pDic );
    }

private:
    std::vector<const std::string*> m_NameArray;
};

}
}
