﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../Include/GlobalOptionParserBase.h"

namespace nn {
namespace g3dTool {

class GlobalOptionParser : public GlobalOptionParserBase
{
public:
    GlobalOptionParser();

    virtual ~GlobalOptionParser()
    {
    }

    //!< @brief ヘルプを表示します。
    void PrintHelp( const char* pToolName, const char* pToolDescription ) override
    {
        NN_UNUSED( pToolDescription );
        NN_GFXTOOL_PRINT("Usage: %-31hs [OPTION]...\n", pToolName);
        NN_GFXTOOL_PRINT("--args-file                            Use 'filename' as arguments.\n");
        NN_GFXTOOL_PRINT("--version                              Display version information and exit.\n");
        NN_GFXTOOL_PRINT("--help                                 Display this help and exit.\n");
        NN_GFXTOOL_PRINT("--silent                               Don't display progress information.\n");
        NN_GFXTOOL_PRINT("--root-config=pathname                 Specify the rootpath of config files.\n");
        NN_GFXTOOL_PRINT("--root-definition=pathname             Specify the rootpath of definition files.\n");
        NN_GFXTOOL_PRINT("--output=filename                      Specify the output binary filename.\n");
        NN_GFXTOOL_PRINT("--verify                               Verify intermediate files and show the error message.\n");
        NN_GFXTOOL_PRINT("--unified-annotation                   Unify annotations which differ between stages.\n");
        NN_GFXTOOL_PRINT("--force-variation                      Consider branch options to be false forcibly.\n");
        NN_GFXTOOL_PRINT("--dump-shader-source=dirname           Dump shader keys, sources, assemblies, symbols and statistics infomations to the specified directory.\n");
        NN_GFXTOOL_PRINT("--glsl-version=string                  Insert \"#version [specified string]\" on the top of source code.\n");
        NN_GFXTOOL_PRINT("--define-macro=macro                   Define preprocessor macro.\n");
        NN_GFXTOOL_PRINT("--api-type=apitype                     Specify target graphics api type.\n");
        NN_GFXTOOL_PRINT("--code-type=codetype                   Specify the shader output code type.\n");
        NN_GFXTOOL_PRINT("--debug-info-level                     Set the debug info level.\n");
        NN_GFXTOOL_PRINT("--debug-info-directory                 Save the debug info data to the specified directory.\n");
        NN_GFXTOOL_PRINT("--shader-cache-directory               Save/Load the compiled result to/from the specified directory.\n");
        NN_GFXTOOL_PRINT("--decompose-binary                     Decompose binary.\n");
        NN_GFXTOOL_PRINT("--glsl-extension                       Specify the GLSL extension to include at the start of the source code.\n");
        NN_GFXTOOL_PRINT("--use-preprocessor-variation           Use preprocessor definitions to create a variation.\n");
        NN_GFXTOOL_PRINT("--jobs                                 Specify the number of thread.\n");
        NN_GFXTOOL_PRINT("--glslc-option-flags                   Specify GLSLCoptionFlags\n");
        NN_GFXTOOL_PRINT("--gfx-shader-converter-options         Specify options for (gfx)ShaderConverter.exe.\n");
        NN_GFXTOOL_PRINT("--variation-begin-ratio                Compile only the shader variation in the range of [variation-begin-ratio, variation-end-ratio] ( The range of all generated shader variations is [0.0, 1.0] ).\n" );
        NN_GFXTOOL_PRINT("--variation-end-ratio                  Compile only the shader variation in the range of [variation-begin-ratio, variation-end-ratio] ( The range of all generated shader variations is [0.0, 1.0] ).\n" );
        NN_GFXTOOL_PRINT("--skip-convert                         Compile the shader but skip the binary conversion.\n");
        NN_GFXTOOL_PRINT("--merge-shader-archive-file                 Specifies shader archive file name which the result merged shader archive contains.");
    }
};

}
}
