﻿#----------------------------------------------------------------------------
# Project:  NintendoWare
#
# Copyright (C)Nintendo All rights reserved.
#
# These coded instructions, statements, and computer programs contain proprietary
# information of Nintendo and/or its licensed developers and are protected by
# national and international copyright laws. They may not be disclosed to third
# parties or copied or duplicated in any form, in whole or in part, without the
# prior written consent of Nintendo.
#
# The content herein is highly confidential and should be handled accordingly.
#----------------------------------------------------------------------------

# 中間ファイルの更新、System.Xml.XmlDocument 型の doc を更新します
def Update(doc):
	# バージョン番号の更新
	version = doc.SelectSingleNode("/nw4f_3dif/@version")
	version.Value = "0.3.0"

	# モデルの更新
	if doc.SelectSingleNode("/nw4f_3dif/model"):
		UpdateModel(doc)

	# スケルタルアニメの更新
	if doc.SelectSingleNode("/nw4f_3dif/skeletal_anim"):
		UpdateSkeletalAnim(doc)

#----------------------------------------------------------
# モデルの更新
def UpdateModel(doc):

	#------------------------------------------------------
	# <material_array> を <renderset_array> の次に移動
	material_array = doc.SelectSingleNode("/nw4f_3dif/model/material_array")
	model = material_array.ParentNode
	model.RemoveChild(material_array)
	renderset_array = doc.SelectSingleNode("/nw4f_3dif/model/renderset_array")
	model.InsertAfter(material_array, renderset_array)

	#------------------------------------------------------
	#  <renderset> bone_index を <shape_info> に移動
	for bone_index in doc.SelectNodes(
		"/nw4f_3dif/model/renderset_array/renderset/@bone_index"):
		renderset = bone_index.OwnerElement
		renderset.RemoveAttributeNode(bone_index)
		shape_index = renderset.GetAttribute("shape_index")
		shape_info = doc.SelectSingleNode("/nw4f_3dif/model/shape_array/shape[" +
			str(int(shape_index) + 1) + "]/shape_info")
		shape_info.SetAttribute("bone_index", bone_index.Value)

	#------------------------------------------------------
	# <alpha_test> val を value に変更
	for alpha_test_val in doc.SelectNodes(
		"/nw4f_3dif/model/material_array/material/render_state/alpha_test/@val"):
		alpha_test = alpha_test_val.OwnerElement
		alpha_test.RemoveAttributeNode(alpha_test_val)
		alpha_test.SetAttribute("value", alpha_test_val.Value)

	#------------------------------------------------------
	# <sampler> name の _i0～_i255 を _e0～_e255 に変更
	for sampler_name in doc.SelectNodes(
		"/nw4f_3dif/model/material_array/material/sampler_array/sampler/@name"):
		if sampler_name.Value.startswith("_i"):
			sampler_name.Value = "_e" + sampler_name.Value.lstrip("_i")

	#------------------------------------------------------
	# <sampler> hint の intensity0～intensity255 を
	# emission0～emission255 に変更
	for sampler_hint in doc.SelectNodes(
		"/nw4f_3dif/model/material_array/material/sampler_array/sampler/@hint"):
		if sampler_hint.Value.startswith("intensity"):
			sampler_hint.Value = "emission" + sampler_hint.Value.lstrip("intensity")

	#------------------------------------------------------
	# <lod> max が 0 であれば、13 に変更
	for lod_max in doc.SelectNodes(
		"/nw4f_3dif/model/material_array/material/sampler_array/sampler/lod/@max"):
		if lod_max.Value == "0":
			lod_max.Value = "13"

	#------------------------------------------------------
	# <material_shader_assign> を削除
	for material_shader_assign in doc.SelectNodes(
		"/nw4f_3dif/model/material_array/material/material_shader_assign"):
		material_shader_assign.ParentNode.RemoveChild(material_shader_assign)

	#------------------------------------------------------
	# <skeleton_info>
	#  - smooth_skinning、normal_matrix を削除
	#  - scale_mode が noscale なら maya に変更
	#  - scale_enable を追加、更新前の scale_mode が noscale なら false
	skeleton_info = doc.SelectSingleNode("/nw4f_3dif/model/skeleton/skeleton_info")
	skeleton_info.RemoveAttribute("smooth_skinning")
	skeleton_info.RemoveAttribute("normal_matrix")
	if skeleton_info.GetAttribute("scale_mode") == "noscale":
		skeleton_info.SetAttribute("scale_mode", "maya")
		skeleton_info.SetAttribute("scale_enable", "false")
	else:
		skeleton_info.SetAttribute("scale_enable", "true")

	#------------------------------------------------------
	# <bone>
	#  - matrix_index のリジッドスキン用 index を -1 に
	#  - render_matrix を追加、更新前の matrix_index が -1 なら false
	for bone in doc.SelectNodes(
		"/nw4f_3dif/model/skeleton/bone_array/bone"):
		matrix_index = bone.GetAttribute("matrix_index")
		bone.SetAttribute("matrix_index", matrix_index + " -1");
		if matrix_index == "-1":
			bone.SetAttribute("render_matrix", "false")
		else:
			bone.SetAttribute("render_matrix", "true")

	#------------------------------------------------------
	# <shape_info> visibility を削除
	for shape_info in doc.SelectNodes(
		"/nw4f_3dif/model/shape_array/shape/shape_info"):
		shape_info.RemoveAttribute("visibility")

	#------------------------------------------------------
	# <shape_shader_assign> を削除
	for shape_shader_assign in doc.SelectNodes(
		"/nw4f_3dif/model/shape_array/shape/shape_shader_assign"):
		shape_shader_assign.ParentNode.RemoveChild(shape_shader_assign)

#----------------------------------------------------------
# スケルタルアニメの更新
def UpdateSkeletalAnim(doc):

	#------------------------------------------------------
	# <skeletal_anim_info>
	#  - scale_mode が noscale なら maya に変更
	#  - scale_enable を追加、更新前の scale_mode が noscale なら false
	skeletal_anim_info = doc.SelectSingleNode("/nw4f_3dif/skeletal_anim/skeletal_anim_info")
	if skeletal_anim_info.GetAttribute("scale_mode") == "noscale":
		skeletal_anim_info.SetAttribute("scale_mode", "maya")
		skeletal_anim_info.SetAttribute("scale_enable", "false")
	else:
		skeletal_anim_info.SetAttribute("scale_enable", "true")

	#------------------------------------------------------
	# <bone_anim>
	#  - name を bone_name に変更
	#  - display_matrix を render_matrix に変更
	for bone_anim in doc.SelectNodes(
		"/nw4f_3dif/skeletal_anim/bone_anim_array/bone_anim"):
		bone_name = bone_anim.GetAttribute("name")
		bone_anim.RemoveAttribute("name")
		bone_anim.SetAttribute("bone_name", bone_name)
		render_matrix = bone_anim.GetAttribute("display_matrix")
		bone_anim.RemoveAttribute("display_matrix")
		bone_anim.SetAttribute("render_matrix", render_matrix)

#----------------------------------------------------------
