﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TextureCompositor
{
    public class Logger
    {
        public bool IsSilent { get; set; } = false;

        public static Logger Instance { get; } = new Logger();

        private Logger()
        {
        }

        public void WriteMessageLine(string message)
        {
            if (this.IsSilent)
            {
                return;
            }

            Console.WriteLine(message);
        }

        public void WriteErrorMessageLine(string message)
        {
            Console.Error.WriteLine($"エラー: {message}");
        }

        public void WriteWarningMessageLine(string message)
        {
            Console.Error.WriteLine($"警告: {message}");
        }

        [Conditional("DEBUG")]
        public void WriteDebugMessageLine(string message)
        {
            Console.WriteLine(message);
        }
    }
}
