﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Runtime.Serialization;
using System.Xml.Serialization;

namespace nw.g3d.nw4f_3dif
{
    /// <summary>
    /// tool_data のシリアライズ対応拡張
    /// </summary>
    public partial class tool_dataType : ISerializable
    {
        public tool_dataType() { }

        public tool_dataType(SerializationInfo info, StreamingContext context)
        {
            using (var reader = new System.IO.StringReader(info.GetString("Text")))
            {
                var deserializer = new XmlSerializer(typeof(tool_dataType));
                var tool_dataType = (tool_dataType)deserializer.Deserialize(reader);
                anyField = tool_dataType.Any;
            }
        }

        public void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            using (var writer = new System.IO.StringWriter())
            {
                var serializer = new XmlSerializer(typeof(tool_dataType));
                serializer.Serialize(writer, this);
                info.AddValue("Text", writer.ToString());
            }
        }
    }

    /// <summary>
    /// user_tool_data のシリアライズ対応拡張
    /// </summary>
    public partial class user_tool_dataType : ISerializable
    {
        public user_tool_dataType() { }

        public user_tool_dataType(SerializationInfo info, StreamingContext context)
        {
            using (var reader = new System.IO.StringReader(info.GetString("Text")))
            {
                var deserializer = new XmlSerializer(typeof(user_tool_dataType));
                var user_tool_dataType = (user_tool_dataType)deserializer.Deserialize(reader);
                anyField = user_tool_dataType.Any;
            }
        }

        public void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            using (var writer = new System.IO.StringWriter())
            {
                var serializer = new XmlSerializer(typeof(user_tool_dataType));
                serializer.Serialize(writer, this);
                info.AddValue("Text", writer.ToString());
            }
        }
    }
}
