﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Text;
using System.Xml;

namespace nw.g3d.nw4f_3dif
{
    /// <summary>
    /// 中間ファイルの名前付き要素
    /// </summary>
    public interface IG3dNamedElement
    {
        /// <summary>
        /// オブジェクトの名前
        /// </summary>
        string name { get; set; }
    }

    //=====================================================================
    public partial class materialType : IG3dNamedElement { }

    public partial class render_infoType : IG3dNamedElement { }

    public partial class samplerType : IG3dNamedElement { }

    public partial class boneType : IG3dNamedElement { }

    public partial class vtx_attribType : IG3dNamedElement { }

    public partial class shapeType : IG3dNamedElement { }

    public partial class key_shapeType : IG3dNamedElement { }

    public partial class shaderType : IG3dNamedElement { }

    public partial class shading_modelType : IG3dNamedElement { }

    public partial class vertex_symbolType : IG3dNamedElement { }

    public partial class geometry_symbolType : IG3dNamedElement { }

    public partial class fragment_symbolType : IG3dNamedElement { }

    public partial class render_info_slotType : IG3dNamedElement { }

    public partial class groupType : IG3dNamedElement { }

    public partial class user_dataType : IG3dNamedElement { }

    public partial class macroType : IG3dNamedElement { }
}
