﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Text;
using System.Xml;
using System.Xml.Serialization;

namespace nw.g3d.nw4f_3dif
{
    /// <summary>
    /// インデックスのヒント付き要素
    /// </summary>
    public interface IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        int index_hint { get; set; }
    }

    //=====================================================================
    public partial class process_logType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class macroType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class user_dataType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class streamType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.stream_index; }
            set { this.stream_index = value; }
        }
    }

    //=====================================================================
    public partial class materialType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class render_infoType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class samplerType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.sampler_index; }
            set { this.sampler_index = value; }
        }
    }

    public partial class shader_optionType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class sampler_assignType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class shader_paramType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class attrib_assignType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class boneType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class vertexType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.vertex_index; }
            set { this.vertex_index = value; }
        }
    }

    public partial class vtx_attribType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.attrib_index; }
            set { this.attrib_index = value; }
        }
    }

    public partial class vtx_bufferType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class inputType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class shapeType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class meshType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class submeshType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.submesh_index; }
            set { this.submesh_index = value; }
        }
    }

    public partial class key_shapeType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class target_attribType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class original_materialType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class original_colorType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class original_texsrtType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    //=====================================================================
    public partial class original_imageType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    //=====================================================================
    public partial class bone_animType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    //=====================================================================
    public partial class per_material_animType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    //=====================================================================
    public partial class shader_param_mat_animType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class param_animType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class pattern_anim_targetType : IG3dIndexHintElement
    {
        private int index = 0;

        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }


    public partial class original_material_animType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class original_color_animType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class original_texsrt_animType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    //=====================================================================
    public partial class tex_patternType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.pattern_index; }
            set { this.pattern_index = value; }
        }
    }

    public partial class tex_pattern_mat_animType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    //=====================================================================
    public partial class bone_vis_bone_animType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    //=====================================================================
    public partial class mat_vis_mat_animType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    //=====================================================================
    public partial class vertex_shape_animType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    //=====================================================================
    public partial class camera_animType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class light_animType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class fog_animType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    //=====================================================================
    public partial class include_pathType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class force_include_fileType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class shaderType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class variationType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    //=====================================================================
    public partial class force_includeType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class shading_modelType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class option_varType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class attrib_varType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class sampler_varType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class block_varType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class shader_storage_block_varType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class textblockType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class pageType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class uniform_varType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class buffer_varType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class render_info_slotType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class interleaveType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class groupType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class shader_srcType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.src_index; }
            set { this.src_index = value; }
        }
    }

    //=====================================================================
    public partial class target_shaderType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class shader_programType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class optionType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class connectionType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class blockType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }

    public partial class uniformType : IG3dIndexHintElement
    {
        /// <summary>
        /// インデックスのヒント
        /// </summary>
        [XmlIgnore]
        public int index_hint
        {
            get { return this.index; }
            set { this.index = value; }
        }
    }
}
