﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Text;
using System.Xml;
using System.Xml.Serialization;

namespace nw.g3d.nw4f_3dif
{
    /// <summary>
    /// カーブコンテナ
    /// </summary>
    public interface IG3dCurveContainer
    {
        /// <summary>
        /// カーブ
        /// </summary>
        [XmlIgnore]
        IG3dCurve Curve { get; set; }

        /// <summary>
        /// ベース値
        /// </summary>
        float base_value { get; set; }
    }

    /// <summary>
    /// 量子化カーブコンテナ
    /// </summary>
    public interface IG3dQuantizedCurveContainer : IG3dCurveContainer
    {
        /// <summary>
        /// カーブ
        /// </summary>
        [XmlIgnore]
        new IG3dQuantizedCurve Curve { get; set; }
    }

    //=====================================================================
    public partial class bone_anim_targetType : IG3dQuantizedCurveContainer
    {
        /// <summary>
        /// カーブ
        /// </summary>
        [XmlIgnore]
        public IG3dQuantizedCurve Curve
        {
            get { return this.Item as IG3dQuantizedCurve; }
            set { this.Item = value; }
        }

        [XmlIgnore]
        IG3dCurve IG3dCurveContainer.Curve
        {
            get { return this.Curve; }
            set { this.Curve = value as IG3dQuantizedCurve; }
        }
    }

    public partial class param_anim_targetType : IG3dQuantizedCurveContainer
    {
        /// <summary>
        /// カーブ
        /// </summary>
        [XmlIgnore]
        public IG3dQuantizedCurve Curve
        {
            get { return this.Item as IG3dQuantizedCurve; }
            set { this.Item = value; }
        }

        [XmlIgnore]
        IG3dCurve IG3dCurveContainer.Curve
        {
            get { return this.Curve; }
            set { this.Curve = value as IG3dQuantizedCurve; }
        }
    }

    public partial class original_color_anim_targetType : IG3dCurveContainer
    {
        /// <summary>
        /// カーブ
        /// </summary>
        [XmlIgnore]
        public IG3dCurve Curve
        {
            get { return this.Item as IG3dCurve; }
            set { this.Item = value; }
        }
    }

    public partial class original_texsrt_anim_targetType : IG3dCurveContainer
    {
        /// <summary>
        /// カーブ
        /// </summary>
        [XmlIgnore]
        public IG3dCurve Curve
        {
            get { return this.Item as IG3dCurve; }
            set { this.Item = value; }
        }
    }

    public partial class pattern_anim_targetType : IG3dQuantizedCurveContainer
    {
        /// <summary>
        /// カーブ
        /// </summary>
        [XmlIgnore]
        public IG3dQuantizedCurve Curve
        {
            get { return this.step_curve; }
            set { this.step_curve = value as step_curveType; }
        }

        [XmlIgnore]
        IG3dCurve IG3dCurveContainer.Curve
        {
            get { return this.Curve; }
            set { this.Curve = value as IG3dQuantizedCurve; }
        }
    }

    public partial class bone_vis_bone_animType : IG3dQuantizedCurveContainer
    {
        /// <summary>
        /// カーブ
        /// </summary>
        [XmlIgnore]
        public IG3dQuantizedCurve Curve
        {
            get { return this.step_curve; }
            set { this.step_curve = value as step_curveType; }
        }

        [XmlIgnore]
        IG3dCurve IG3dCurveContainer.Curve
        {
            get { return this.Curve; }
            set { this.Curve = value as IG3dQuantizedCurve; }
        }
    }

    public partial class mat_vis_mat_animType : IG3dQuantizedCurveContainer
    {
        /// <summary>
        /// カーブ
        /// </summary>
        [XmlIgnore]
        public IG3dQuantizedCurve Curve
        {
            get { return this.step_curve; }
            set { this.step_curve = value as step_curveType; }
        }

        [XmlIgnore]
        IG3dCurve IG3dCurveContainer.Curve
        {
            get { return this.Curve; }
            set { this.Curve = value as IG3dQuantizedCurve; }
        }
    }

    public partial class shape_anim_targetType : IG3dQuantizedCurveContainer
    {
        /// <summary>
        /// カーブ
        /// </summary>
        [XmlIgnore]
        public IG3dQuantizedCurve Curve
        {
            get { return this.Item as IG3dQuantizedCurve; }
            set { this.Item = value; }
        }

        [XmlIgnore]
        IG3dCurve IG3dCurveContainer.Curve
        {
            get { return this.Curve; }
            set { this.Curve = value as IG3dQuantizedCurve; }
        }
    }

    public partial class camera_anim_targetType : IG3dQuantizedCurveContainer
    {
        /// <summary>
        /// カーブ
        /// </summary>
        [XmlIgnore]
        public IG3dQuantizedCurve Curve
        {
            get { return this.Item as IG3dQuantizedCurve; }
            set { this.Item = value; }
        }

        [XmlIgnore]
        IG3dCurve IG3dCurveContainer.Curve
        {
            get { return this.Curve; }
            set { this.Curve = value as IG3dQuantizedCurve; }
        }
    }

    public partial class light_anim_targetType : IG3dQuantizedCurveContainer
    {
        /// <summary>
        /// カーブ
        /// </summary>
        [XmlIgnore]
        public IG3dQuantizedCurve Curve
        {
            get { return this.Item as IG3dQuantizedCurve; }
            set { this.Item = value; }
        }

        [XmlIgnore]
        IG3dCurve IG3dCurveContainer.Curve
        {
            get { return this.Curve; }
            set { this.Curve = value as IG3dQuantizedCurve; }
        }
    }

    public partial class fog_anim_targetType : IG3dQuantizedCurveContainer
    {
        /// <summary>
        /// カーブ
        /// </summary>
        [XmlIgnore]
        public IG3dQuantizedCurve Curve
        {
            get { return this.Item as IG3dQuantizedCurve; }
            set { this.Item = value; }
        }

        [XmlIgnore]
        IG3dCurve IG3dCurveContainer.Curve
        {
            get { return this.Curve; }
            set { this.Curve = value as IG3dQuantizedCurve; }
        }
    }
}
