﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using nw.g3d.iflib;
using nw4f.tinymathlib;
using Vector3 = nw4f.tinymathlib.Vector3;

namespace nw4f.meshlib
{
    using FaceWeList = ResizableList<FaceWingedEdge>;

    /// <summary>
    /// 各頂点にどのエッジがぶら下がっているかを
    /// </summary>
    public class FaceWingedEdge : ICloneable
    {
        internal ResizableList<WingedEdge> edges { get; set; } = new ResizableList<WingedEdge>();
        public ResizableList<WingedEdge> Edges
        {
            get { return edges; }
        }

        public WingedEdge Remove(int vid)
        {
            WingedEdge result = null;
            int e = 0;
            for (e = 0; e < edges.Count; e++)
            {
                if (edges[e].Vertex0 == vid || edges[e].Vertex1 == vid)
                {
                    result = edges[e];
                    edges.RemoveAt(e);
                    break;
                }
            }
            return result;
        }

        public object Clone()
        {
            FaceWingedEdge ret = new FaceWingedEdge();
            ret.edges = ResizableList<WingedEdge>.Clone(edges);
            return ret;
        }
    }

    public partial class WingedEdgeMesh
    {
        private Dictionary<SourceKey, FaceWeList> _FaceEdgeList;

        /// <summary>
        /// 代表キー（ほとんどの場合は頂点）に関して、Faceに所属するEdgeリストを作成します。
        /// </summary>
        public FaceWeList RepFEL
        {
            get
            {
                if (_FaceEdgeList != null && _FaceEdgeList.ContainsKey(mRepresentativeKey))
                {
                    return _FaceEdgeList[mRepresentativeKey];
                }
                return null;
            }
        }

        public FaceWeList GetFaceWingedEdgeList(SourceType type, string name)
        {
            SourceKey key = new SourceKey(type, name);
            if (_FaceEdgeList.ContainsKey(key))
            {
                return _FaceEdgeList[key];
            }
            return null;
        }

        /// <summary>
        /// FaceEdgeListを作成する。
        /// Faceに所属するエッジにアクセスする機能を提供する。
        /// CreateAll() 関数によって呼び出されないので、明示的に使ってください。
        /// </summary>
        public void CreateFaceEdgeList()
        {
            _FaceEdgeList = new Dictionary<SourceKey, FaceWeList>();
            foreach (var wingedEdge in mWingedEdges)
            {
                CreateFaceEdgeList(wingedEdge.Key.type, wingedEdge.Key.name);
            }
        }

        /// <summary>
        /// FaceEdgeListを作成する。
        /// FaceEdgeListは、簡略化などの操作で位相が変わらない間のみ有効なオブジェクトなので必要に応じて、生成し削除を推奨
        /// </summary>
        /// <param name="type"></param>
        /// <param name="name"></param>
        public void CreateFaceEdgeList(SourceType type, string name)
        {
            var key = new SourceKey(type, name);
            if (!mWingedEdges.ContainsKey(key))
            {
                return;
            }
            if (!_FaceEdgeList.ContainsKey(key))
            {
                _FaceEdgeList.Add(key, new FaceWeList());
            }

            var faceEdgeList = _FaceEdgeList[key];
            var wingedEdges = mWingedEdges[key];
            faceEdgeList.Resize(mMesh.FaceN + 1, null);
            for (var i = 0; i < mMesh.FaceN + 1; i++)
            {
                faceEdgeList[i] = new FaceWingedEdge();
            }
            // 全てのEdgeをFace毎に分類する
            foreach (var edge in wingedEdges)
            {
                if (edge.Face0 != int.MaxValue)
                {
                    faceEdgeList[edge.Face0].Edges.Add(edge);
                }
                else
                {
                    faceEdgeList[mMesh.FaceN].Edges.Add(edge);
                }
                if (edge.Face1 != int.MaxValue)
                {
                    faceEdgeList[edge.Face1].Edges.Add(edge);
                }
                else
                {
                    faceEdgeList[mMesh.FaceN].Edges.Add(edge);
                }
            }
        }

        /// <summary>
        /// オブジェクト開放
        /// </summary>
        public void DestroyFaceEdgeList()
        {
            _FaceEdgeList = null;
        }
    }
}
