﻿using Nintendo.G3dTool.Entities;
using Nintendo.G3dTool.Extensions;
using Nintendo.ToolFoundation.CommandLine;
using nw.g3d.iflib;
using nw.g3d.nw4f_3dif;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Reflection;

namespace _3dIntermediateFileMaterialGenerator
{
    public class Program
    {
        static void Main(string[] args)
        {
            MaterialGenerator generator = new MaterialGenerator();
#if !DEBUG
            try
#endif
            {
                var context = new Context(args);
                string assemblyDir = System.IO.Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location);
                context.XsdBasePath = System.IO.Path.Combine(assemblyDir, "3dIntermediateFileXsd");
                generator.Execute(context);
            }
#if !DEBUG
            catch (Exception exception)
            {
                generator.Context.WriteErrorMessage(exception.Message);
                var innerException = exception.InnerException;
                while (innerException != null)
                {
                    generator.Context.WriteErrorMessage(innerException.Message);
                    innerException = innerException.InnerException;
                }

                Environment.Exit(1);
            }
#endif
        }
    }
}
