﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.G3dTool.Entities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using System.Xml.Schema;
using System.Xml.Serialization;

namespace nw.g3d.iflib.nw3de
{
    /// <summary>
    /// 3DEditor の追加参照パス (nw3de は3DEditor のツールデータ用の接頭語)
    /// </summary>
    [Serializable]
    public class nw3de_CombinerOptionInfo : ToolDataObject
    {
        [XmlArrayItem("CombinerOption")]
        public List<CombinerOption> CombinerOptions { get; set; }

        public nw3de_CombinerOptionInfo()
        {
            CombinerOptions = new List<CombinerOption>();
        }
    }

    [Serializable]
    public class CombinerOption : IXmlSerializable
    {
        // ID
        [XmlAttribute]
        public string Id { get; set; }

        // 拡張子を除いたファイル名
        [XmlAttribute]
        public string FileName { get; set; }

        [XmlIgnore]
        public bool Updated { get; set; } = false;

        public XmlSchema GetSchema()
        {
            return null;
        }

        public void ReadXml(XmlReader reader)
        {
            reader.MoveToContent();
            Id = reader.GetAttribute("Id");

            FileName = reader.GetAttribute("FileName");
            reader.Read();
        }

        public void WriteXml(XmlWriter writer)
        {
            writer.WriteAttributeString("Id", Id);
            if (!string.IsNullOrEmpty(FileName))
            {
                writer.WriteAttributeString("FileName", FileName);
            }
        }
    }
}
