﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace nw.g3d.iflib
{
    public interface IfPseudoVertexCache
    {
        /// <summary>
        /// 頂点キャッシュのサイズです。
        /// </summary>
        int VertexCacheSize { get; }

        /// <summary>
        /// キャッシュを初期化します。
        /// </summary>
        void Clear();

        /// <summary>
        /// 任意の座標IDがキャッシュされているかを取得します。
        /// </summary>
        /// <param name="positionId">確認したい座標 ID です。</param>
        /// <returns>キャッシュされていれば true を返します。</returns>
        bool IsContains(int positionId);

        /// <summary>
        /// キューに座標IDを追加します。
        /// </summary>
        /// <param name="positionId">座標 ID です。</param>
        void EnqueuePosition(int positionId);
    }
}
