﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;

namespace nw.g3d.iflib
{
    /// <summary>
    /// ポリゴン最適化のインターフェースです。
    /// </summary>
    public interface IfOptimizeAlgorithm
    {
        /// <summary>
        /// トライアングルリストの情報を事前に解析します。
        /// </summary>
        /// <param name="polygonMesh">最適化対象です。</param>
        void Analyze(IfPolygonMesh polygonMesh);

        /// <summary>
        /// トライアングルリストの頂点キャッシュ最適化処理
        /// </summary>
        /// <param name="polygonMesh">最適化対象です。</param>
        /// <param name="optimizedPolygonPrimitive">最適化結果を格納します。</param>
        /// <param name="startIndex">最適化の起点となるインデクスです。</param>
        void Optimize(IfPolygonMesh polygonMesh, IList<IfPolygonPrimitive> optimizedPolygonPrimitive, int startIndex);
    }
}
