﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Diagnostics;
using System.IO;
using nw.g3d.nw4f_3dif;

namespace nw.g3d.iflib
{
    // テキストシェイプアニメーション中間ファイルフォーマッタ
    internal static class IfTextShapeAnimFormatter
    {
        // shape_anim のフォーマット
        internal static void Format(TextReader rd, TextWriter wt)
        {
            // shape_anim
            wt.WriteLine($"<{G3dConstant.ShapeAnimElementName} {rd.ReadLine()}");

            // process_log
            string process_log_array = rd.ReadLine();
            string shape_anim_info;
            if (process_log_array == "<process_log_array")
            {
                IfTextFormatterUtility.Format_process_log_array(rd, wt);
                shape_anim_info = rd.ReadLine();
            }
            else
            {
                shape_anim_info = process_log_array;
            }

            // shape_anim_info
            Nintendo.Foundation.Contracts.Assertion.Operation.True(shape_anim_info == "<shape_anim_info");
            FormatShapeAnimInfo(rd, wt);

            // vertex_shape_anim
            string vertex_shape_anim_array = rd.ReadLine();
            string user_data_array;
            if (vertex_shape_anim_array == "<vertex_shape_anim_array")
            {
                Format_vertex_shape_anim(rd, wt);
                user_data_array = rd.ReadLine();
            }
            else
            {
                user_data_array = vertex_shape_anim_array;
            }

            // user_data
            string stream_array;
            if (user_data_array == "<user_data_array")
            {
                IfTextFormatterUtility.Format_user_data_array(rd, wt, string.Empty);
                stream_array = rd.ReadLine();
            }
            else
            {
                stream_array = user_data_array;
            }

            // stream
            string comment;
            if (stream_array == "<stream_array")
            {
                IfTextFormatterUtility.Format_stream(rd, wt);
                comment = rd.ReadLine();
            }
            else
            {
                comment = stream_array;
            }

            // comment
            string tool_data;
            if (comment == "<comment")
            {
                IfTextFormatterUtility.FormatComment(rd, wt, string.Empty);
                tool_data = rd.ReadLine();
            }
            else
            {
                tool_data = comment;
            }

            // tool_data
            string user_tool_data;
            if (tool_data == "<tool_data>")
            {
                IfTextFormatterUtility.FormatToolData(rd, wt, string.Empty);
                user_tool_data = rd.ReadLine();
            }
            else
            {
                user_tool_data = tool_data;
            }

            // user_tool_data
            string close_shape_anim;
            if (user_tool_data == "<user_tool_data>")
            {
                IfTextFormatterUtility.FormatUserToolData(rd, wt, string.Empty);
                close_shape_anim = rd.ReadLine();
            }
            else
            {
                close_shape_anim = user_tool_data;
            }

            Nintendo.Foundation.Contracts.Assertion.Operation.True(close_shape_anim == "</shape_anim>");
            wt.WriteLine(close_shape_anim);
        }

        //---------------------------------------------------------------------
        #region shape_anim_info
        // shape_anim_info のフォーマット
        private static void FormatShapeAnimInfo(TextReader rd, TextWriter wt)
        {
            // shape_anim_info
            wt.WriteLine("<shape_anim_info {0} {1}", rd.ReadLine(), rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", IfTextFormatterUtility.RemoveSlashBracket(rd.ReadLine()));
            wt.WriteLine("/>");
        }
        #endregion

        //---------------------------------------------------------------------
        #region vertex_shape_anim
        // vertex_shape_anim のフォーマット
        private static void Format_vertex_shape_anim(TextReader rd, TextWriter wt)
        {
            // vertex_shape_anim_array
            wt.WriteLine("<vertex_shape_anim_array {0}", rd.ReadLine());

            while (true)
            {
                // vertex_shape_anim
                string vertex_shape_anim = rd.ReadLine();
                if (vertex_shape_anim != "<vertex_shape_anim")
                {
                    Nintendo.Foundation.Contracts.Assertion.Operation.True(vertex_shape_anim == "</vertex_shape_anim_array>");
                    wt.WriteLine("{0}", vertex_shape_anim);
                    break;
                }
                wt.WriteLine("\t{0} {1} {2} {3}",
                    vertex_shape_anim, rd.ReadLine(), rd.ReadLine(), rd.ReadLine());

                string close_vertex_shape_anim = Format_shape_anim_target(rd, wt);
                Nintendo.Foundation.Contracts.Assertion.Operation.True(close_vertex_shape_anim == "</vertex_shape_anim>");
                wt.WriteLine("\t{0}", close_vertex_shape_anim);
            }
        }

        // shape_anim_target のフォーマット
        private static string Format_shape_anim_target(TextReader rd, TextWriter wt)
        {
            while (true)
            {
                // shape_anim_target
                string shape_anim_target = rd.ReadLine();
                if (shape_anim_target != "<shape_anim_target")
                {
                    return shape_anim_target;
                }
                string key_name = rd.ReadLine();
                string base_value = rd.ReadLine();
                wt.WriteLine("\t\t{0} {1} {2}",
                    shape_anim_target, key_name, base_value);
                if (base_value.EndsWith(" />")) { continue; }

                IfTextFormatterUtility.FormatCurve(rd, wt, "\t\t\t");

                string close_shape_anim_target = rd.ReadLine();
                Nintendo.Foundation.Contracts.Assertion.Operation.True(close_shape_anim_target == "</shape_anim_target>");
                wt.WriteLine("\t\t{0}", close_shape_anim_target);
            }
        }
        #endregion

        //---------------------------------------------------------------------
    }
}
