﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Diagnostics;
using System.IO;
using nw.g3d.nw4f_3dif;

namespace nw.g3d.iflib
{
    // テキストシーンアニメーション中間ファイルフォーマッタ
    internal static class IfTextSceneAnimFormatter
    {
        // scene_anim のフォーマット
        internal static void Format(TextReader rd, TextWriter wt)
        {
            // scene_anim
            wt.WriteLine($"<{G3dConstant.SceneAnimElementName} {rd.ReadLine()}");

            // process_log
            string process_log_array = rd.ReadLine();
            string scene_anim_info;
            if (process_log_array == "<process_log_array")
            {
                IfTextFormatterUtility.Format_process_log_array(rd, wt);
                scene_anim_info = rd.ReadLine();
            }
            else
            {
                scene_anim_info = process_log_array;
            }

            // scene_anim_info
            Nintendo.Foundation.Contracts.Assertion.Operation.True(scene_anim_info == "<scene_anim_info");
            FormatSceneAnimInfo(rd, wt);

            // camera_anim_array
            string camera_anim_array = rd.ReadLine();
            string light_anim_array;
            if (camera_anim_array == "<camera_anim_array")
            {
                Format_camera_anim(rd, wt);
                light_anim_array = rd.ReadLine();
            }
            else
            {
                light_anim_array = camera_anim_array;
            }

            // light_anim_array
            string fog_anim_array;
            if (light_anim_array == "<light_anim_array")
            {
                Format_light_anim(rd, wt);
                fog_anim_array = rd.ReadLine();
            }
            else
            {
                fog_anim_array = light_anim_array;
            }

            // fog_anim_array
            string user_data_array;
            if (fog_anim_array == "<fog_anim_array")
            {
                Format_fog_anim(rd, wt);
                user_data_array = rd.ReadLine();
            }
            else
            {
                user_data_array = fog_anim_array;
            }

            // user_data
            string stream_array;
            if (user_data_array == "<user_data_array")
            {
                IfTextFormatterUtility.Format_user_data_array(rd, wt, string.Empty);
                stream_array = rd.ReadLine();
            }
            else
            {
                stream_array = user_data_array;
            }

            // stream
            string comment;
            if (stream_array == "<stream_array")
            {
                IfTextFormatterUtility.Format_stream(rd, wt);
                comment = rd.ReadLine();
            }
            else
            {
                comment = stream_array;
            }

            // comment
            string tool_data;
            if (comment == "<comment")
            {
                IfTextFormatterUtility.FormatComment(rd, wt, string.Empty);
                tool_data = rd.ReadLine();
            }
            else
            {
                tool_data = comment;
            }

            // tool_data
            string user_tool_data;
            if (tool_data == "<tool_data>")
            {
                IfTextFormatterUtility.FormatToolData(rd, wt, string.Empty);
                user_tool_data = rd.ReadLine();
            }
            else
            {
                user_tool_data = tool_data;
            }

            // user_tool_data
            string close_scene_anim;
            if (user_tool_data == "<user_tool_data>")
            {
                IfTextFormatterUtility.FormatUserToolData(rd, wt, string.Empty);
                close_scene_anim = rd.ReadLine();
            }
            else
            {
                close_scene_anim = user_tool_data;
            }

            Nintendo.Foundation.Contracts.Assertion.Operation.True(close_scene_anim == "</scene_anim>");
            wt.WriteLine(close_scene_anim);
        }

        //---------------------------------------------------------------------
        #region scene_anim_info
        // scene_anim_info のフォーマット
        private static void FormatSceneAnimInfo(TextReader rd, TextWriter wt)
        {
            // scene_anim_info
            wt.WriteLine("<scene_anim_info");
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", IfTextFormatterUtility.RemoveSlashBracket(rd.ReadLine()));
            wt.WriteLine("/>");
        }
        #endregion

        //---------------------------------------------------------------------
        #region camera_anim
        // camera_anim のフォーマット
        private static void Format_camera_anim(TextReader rd, TextWriter wt)
        {
            // camera_anim_array
            wt.WriteLine("<camera_anim_array {0}", rd.ReadLine());

            while (true)
            {
                // camera_anim
                string camera_anim = rd.ReadLine();
                if (camera_anim != "<camera_anim")
                {
                    Nintendo.Foundation.Contracts.Assertion.Operation.True(camera_anim == "</camera_anim_array>");
                    wt.WriteLine("{0}", camera_anim);
                    break;
                }
                wt.WriteLine("\t{0} {1} {2}",
                    camera_anim, rd.ReadLine(), rd.ReadLine());
                wt.WriteLine("\t\t{0} {1}", rd.ReadLine(), rd.ReadLine());
                wt.WriteLine("\t\t{0}", rd.ReadLine());

                string projection_mode = rd.ReadLine();
                if (projection_mode.EndsWith(" />"))
                {
                    wt.WriteLine("\t\t{0}", IfTextFormatterUtility.RemoveSlashBracket(projection_mode));
                    wt.WriteLine("\t/>");
                    continue;
                }
                else
                {
                    wt.WriteLine("\t\t{0}", IfTextFormatterUtility.RemoveBracket(projection_mode));
                    wt.WriteLine("\t>");
                }

                // user_data
                string user_data_array = Format_camera_anim_target(rd, wt);
                string comment;
                if (user_data_array == "<user_data_array")
                {
                    IfTextFormatterUtility.Format_user_data_array(rd, wt, "\t\t");
                    comment = rd.ReadLine();
                }
                else
                {
                    comment = user_data_array;
                }

                // comment
                string tool_data;
                if (comment == "<comment")
                {
                    IfTextFormatterUtility.FormatComment(rd, wt, "\t\t");
                    tool_data = rd.ReadLine();
                }
                else
                {
                    tool_data = comment;
                }

                // tool_data
                string user_tool_data;
                if (tool_data == "<tool_data>")
                {
                    IfTextFormatterUtility.FormatToolData(rd, wt, "\t\t");
                    user_tool_data = rd.ReadLine();
                }
                else
                {
                    user_tool_data = tool_data;
                }

                // user_tool_data
                string close_camera_anim;
                if (user_tool_data == "<user_tool_data>")
                {
                    IfTextFormatterUtility.FormatUserToolData(rd, wt, "\t\t");
                    close_camera_anim = rd.ReadLine();
                }
                else
                {
                    close_camera_anim = user_tool_data;
                }

                Nintendo.Foundation.Contracts.Assertion.Operation.True(close_camera_anim == "</camera_anim>");
                wt.WriteLine("\t{0}", close_camera_anim);
            }
        }

        // camera_anim_target のフォーマット
        private static string Format_camera_anim_target(TextReader rd, TextWriter wt)
        {
            while (true)
            {
                // camera_anim_target
                string camera_anim_target = rd.ReadLine();
                if (camera_anim_target != "<camera_anim_target")
                {
                    return camera_anim_target;
                }
                string target = rd.ReadLine();
                string base_value = rd.ReadLine();
                wt.WriteLine("\t\t{0} {1} {2}",
                    camera_anim_target, target, base_value);
                if (base_value.EndsWith(" />")) { continue; }

                // curve
                IfTextFormatterUtility.FormatCurve(rd, wt, "\t\t\t");

                string close_camera_anim_target = rd.ReadLine();
                Nintendo.Foundation.Contracts.Assertion.Operation.True(close_camera_anim_target == "</camera_anim_target>");
                wt.WriteLine("\t\t{0}", close_camera_anim_target);
            }
        }
        #endregion

        //---------------------------------------------------------------------
        #region light_anim
        // light_anim のフォーマット
        private static void Format_light_anim(TextReader rd, TextWriter wt)
        {
            // light_anim_array
            wt.WriteLine("<light_anim_array {0}", rd.ReadLine());

            while (true)
            {
                // light_anim
                string light_anim = rd.ReadLine();
                if (light_anim != "<light_anim")
                {
                    Nintendo.Foundation.Contracts.Assertion.Operation.True(light_anim == "</light_anim_array>");
                    wt.WriteLine("{0}", light_anim);
                    break;
                }
                wt.WriteLine("\t{0} {1} {2}",
                    light_anim, rd.ReadLine(), rd.ReadLine());
                wt.WriteLine("\t\t{0} {1}", rd.ReadLine(), rd.ReadLine());
                wt.WriteLine("\t\t{0}", rd.ReadLine());
                wt.WriteLine("\t\t{0}", rd.ReadLine());

                string angle_attn_func = rd.ReadLine();
                if (angle_attn_func.EndsWith(" />"))
                {
                    wt.WriteLine("\t\t{0}", IfTextFormatterUtility.RemoveSlashBracket(angle_attn_func));
                    wt.WriteLine("\t/>");
                    continue;
                }
                else
                {
                    wt.WriteLine("\t\t{0}", IfTextFormatterUtility.RemoveBracket(angle_attn_func));
                    wt.WriteLine("\t>");
                }

                // user_data
                string user_data_array = Format_light_anim_target(rd, wt);
                string comment;
                if (user_data_array == "<user_data_array")
                {
                    IfTextFormatterUtility.Format_user_data_array(rd, wt, "\t\t");
                    comment = rd.ReadLine();
                }
                else
                {
                    comment = user_data_array;
                }

                // comment
                string tool_data;
                if (comment == "<comment")
                {
                    IfTextFormatterUtility.FormatComment(rd, wt, "\t\t");
                    tool_data = rd.ReadLine();
                }
                else
                {
                    tool_data = comment;
                }

                // tool_data
                string user_tool_data;
                if (tool_data == "<tool_data>")
                {
                    IfTextFormatterUtility.FormatToolData(rd, wt, "\t\t");
                    user_tool_data = rd.ReadLine();
                }
                else
                {
                    user_tool_data = tool_data;
                }

                // user_tool_data
                string close_light_anim;
                if (user_tool_data == "<user_tool_data>")
                {
                    IfTextFormatterUtility.FormatUserToolData(rd, wt, "\t\t");
                    close_light_anim = rd.ReadLine();
                }
                else
                {
                    close_light_anim = user_tool_data;
                }

                Nintendo.Foundation.Contracts.Assertion.Operation.True(close_light_anim == "</light_anim>");
                wt.WriteLine("\t{0}", close_light_anim);
            }
        }

        // light_anim_target のフォーマット
        private static string Format_light_anim_target(TextReader rd, TextWriter wt)
        {
            while (true)
            {
                // light_anim_target
                string light_anim_target = rd.ReadLine();
                if (light_anim_target != "<light_anim_target")
                {
                    return light_anim_target;
                }
                string target = rd.ReadLine();
                string base_value = rd.ReadLine();
                wt.WriteLine("\t\t{0} {1} {2}",
                    light_anim_target, target, base_value);
                if (base_value.EndsWith(" />")) { continue; }

                // curve
                IfTextFormatterUtility.FormatCurve(rd, wt, "\t\t\t");

                string close_light_anim_target = rd.ReadLine();
                Nintendo.Foundation.Contracts.Assertion.Operation.True(close_light_anim_target == "</light_anim_target>");
                wt.WriteLine("\t\t{0}", close_light_anim_target);
            }
        }
        #endregion

        //---------------------------------------------------------------------
        #region fog_anim
        // fog_anim のフォーマット
        private static void Format_fog_anim(TextReader rd, TextWriter wt)
        {
            // fog_anim_array
            wt.WriteLine("<fog_anim_array {0}", rd.ReadLine());

            while (true)
            {
                // fog_anim
                string fog_anim = rd.ReadLine();
                if (fog_anim != "<fog_anim")
                {
                    Nintendo.Foundation.Contracts.Assertion.Operation.True(fog_anim == "</fog_anim_array>");
                    wt.WriteLine("{0}", fog_anim);
                    break;
                }
                wt.WriteLine("\t{0} {1} {2}",
                    fog_anim, rd.ReadLine(), rd.ReadLine());
                wt.WriteLine("\t\t{0} {1}", rd.ReadLine(), rd.ReadLine());

                string dist_attn_func = rd.ReadLine();
                if (dist_attn_func.EndsWith(" />"))
                {
                    wt.WriteLine("\t\t{0}", IfTextFormatterUtility.RemoveSlashBracket(dist_attn_func));
                    wt.WriteLine("\t/>");
                    continue;
                }
                else
                {
                    wt.WriteLine("\t\t{0}", IfTextFormatterUtility.RemoveBracket(dist_attn_func));
                    wt.WriteLine("\t>");
                }

                // user_data
                string user_data_array = Format_fog_anim_target(rd, wt);
                string comment;
                if (user_data_array == "<user_data_array")
                {
                    IfTextFormatterUtility.Format_user_data_array(rd, wt, "\t\t");
                    comment = rd.ReadLine();
                }
                else
                {
                    comment = user_data_array;
                }

                // comment
                string tool_data;
                if (comment == "<comment")
                {
                    IfTextFormatterUtility.FormatComment(rd, wt, "\t\t");
                    tool_data = rd.ReadLine();
                }
                else
                {
                    tool_data = comment;
                }

                // tool_data
                string user_tool_data;
                if (tool_data == "<tool_data>")
                {
                    IfTextFormatterUtility.FormatToolData(rd, wt, "\t\t");
                    user_tool_data = rd.ReadLine();
                }
                else
                {
                    user_tool_data = tool_data;
                }

                // user_tool_data
                string close_fog_anim;
                if (user_tool_data == "<user_tool_data>")
                {
                    IfTextFormatterUtility.FormatUserToolData(rd, wt, "\t\t");
                    close_fog_anim = rd.ReadLine();
                }
                else
                {
                    close_fog_anim = user_tool_data;
                }

                Nintendo.Foundation.Contracts.Assertion.Operation.True(close_fog_anim == "</fog_anim>");
                wt.WriteLine("\t{0}", close_fog_anim);
            }
        }

        // fog_anim_target のフォーマット
        private static string Format_fog_anim_target(TextReader rd, TextWriter wt)
        {
            while (true)
            {
                // fog_anim_target
                string fog_anim_target = rd.ReadLine();
                if (fog_anim_target != "<fog_anim_target")
                {
                    return fog_anim_target;
                }
                string target = rd.ReadLine();
                string base_value = rd.ReadLine();
                wt.WriteLine("\t\t{0} {1} {2}",
                    fog_anim_target, target, base_value);
                if (base_value.EndsWith(" />")) { continue; }

                // curve
                IfTextFormatterUtility.FormatCurve(rd, wt, "\t\t\t");

                string close_fog_anim_target = rd.ReadLine();
                Nintendo.Foundation.Contracts.Assertion.Operation.True(close_fog_anim_target == "</fog_anim_target>");
                wt.WriteLine("\t\t{0}", close_fog_anim_target);
            }
        }
        #endregion

        //---------------------------------------------------------------------
    }
}
