﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Diagnostics;
using System.IO;
using nw.g3d.nw4f_3dif;

namespace nw.g3d.iflib
{
    // テキストマテリアルビジビリティアニメーション中間ファイルフォーマッタ
    internal static class IfTextMatVisibilityAnimFormatter
    {
        // mat_visibility_anim のフォーマット
        internal static void Format(TextReader rd, TextWriter wt)
        {
            // mat_visibility_anim
            wt.WriteLine($"<{G3dConstant.MatVisibilityAnimElementName} {rd.ReadLine()}");

            // process_log
            string process_log_array = rd.ReadLine();
            string mat_visibility_anim_info;
            if (process_log_array == "<process_log_array")
            {
                IfTextFormatterUtility.Format_process_log_array(rd, wt);
                mat_visibility_anim_info = rd.ReadLine();
            }
            else
            {
                mat_visibility_anim_info = process_log_array;
            }

            // mat_visibility_anim_info
            Nintendo.Foundation.Contracts.Assertion.Operation.True(mat_visibility_anim_info == "<mat_visibility_anim_info");
            FormatMatVisibilityAnimInfo(rd, wt);

            // mat_vis_mat_anim_array
            string mat_vis_mat_anim_array = rd.ReadLine();
            string user_data_array;
            if (mat_vis_mat_anim_array == "<mat_vis_mat_anim_array")
            {
                Format_mat_vis_mat_anim(rd, wt);
                user_data_array = rd.ReadLine();
            }
            else
            {
                user_data_array = mat_vis_mat_anim_array;
            }

            // user_data
            string stream_array;
            if (user_data_array == "<user_data_array")
            {
                IfTextFormatterUtility.Format_user_data_array(rd, wt, string.Empty);
                stream_array = rd.ReadLine();
            }
            else
            {
                stream_array = user_data_array;
            }

            // stream
            string comment;
            if (stream_array == "<stream_array")
            {
                IfTextFormatterUtility.Format_stream(rd, wt);
                comment = rd.ReadLine();
            }
            else
            {
                comment = stream_array;
            }

            // comment
            string tool_data;
            if (comment == "<comment")
            {
                IfTextFormatterUtility.FormatComment(rd, wt, string.Empty);
                tool_data = rd.ReadLine();
            }
            else
            {
                tool_data = comment;
            }

            // tool_data
            string user_tool_data;
            if (tool_data == "<tool_data>")
            {
                IfTextFormatterUtility.FormatToolData(rd, wt, string.Empty);
                user_tool_data = rd.ReadLine();
            }
            else
            {
                user_tool_data = tool_data;
            }

            // user_tool_data
            string close_mat_visibility_anim;
            if (user_tool_data == "<user_tool_data>")
            {
                IfTextFormatterUtility.FormatUserToolData(rd, wt, string.Empty);
                close_mat_visibility_anim = rd.ReadLine();
            }
            else
            {
                close_mat_visibility_anim = user_tool_data;
            }

            Nintendo.Foundation.Contracts.Assertion.Operation.True(close_mat_visibility_anim == "</mat_visibility_anim>");
            wt.WriteLine(close_mat_visibility_anim);
        }

        //---------------------------------------------------------------------
        // mat_visibility_anim_info のフォーマット
        private static void FormatMatVisibilityAnimInfo(TextReader rd, TextWriter wt)
        {
            // mat_visibility_anim_info
            wt.WriteLine("<mat_visibility_anim_info {0} {1}", rd.ReadLine(), rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", IfTextFormatterUtility.RemoveSlashBracket(rd.ReadLine()));
            wt.WriteLine("/>");
        }

        //---------------------------------------------------------------------
        // mat_vis_mat_anim のフォーマット
        private static void Format_mat_vis_mat_anim(TextReader rd, TextWriter wt)
        {
            // mat_vis_mat_anim_array
            wt.WriteLine("<mat_vis_mat_anim_array {0}", rd.ReadLine());

            while (true)
            {
                // mat_vis_mat_anim
                string mat_vis_mat_anim = rd.ReadLine();
                if (mat_vis_mat_anim != "<mat_vis_mat_anim")
                {
                    Nintendo.Foundation.Contracts.Assertion.Operation.True(mat_vis_mat_anim == "</mat_vis_mat_anim_array>");
                    wt.WriteLine("{0}", mat_vis_mat_anim);
                    break;
                }
                wt.WriteLine("\t{0} {1} {2}",
                    mat_vis_mat_anim, rd.ReadLine(), rd.ReadLine());
                string base_value = rd.ReadLine();
                if (base_value.EndsWith(" />"))
                {
                    wt.WriteLine("\t\t{0}", IfTextFormatterUtility.RemoveSlashBracket(base_value));
                    wt.WriteLine("\t/>");
                    continue;
                }
                else
                {
                    wt.WriteLine("\t\t{0}", IfTextFormatterUtility.RemoveBracket(base_value));
                    wt.WriteLine("\t>");
                }

                // step_curve
                string step_curve = rd.ReadLine();
                Nintendo.Foundation.Contracts.Assertion.Operation.True(step_curve == "<step_curve");
                IfTextFormatterUtility.Format_step_curve(rd, wt, "\t\t");

                string close_mat_vis_mat_anim = rd.ReadLine();
                Nintendo.Foundation.Contracts.Assertion.Operation.True(close_mat_vis_mat_anim == "</mat_vis_mat_anim>");
                wt.WriteLine("\t{0}", close_mat_vis_mat_anim);
            }
        }
    }
}
