﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.Foundation.IO;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Resources;
using System.Text;
using System.Threading.Tasks;

namespace nw.g3d.ifcvtr
{
    public class CommandLineOptions
    {
        static CommandLineOptions()
        {
            resourceManager = new ResourceManager("nw.g3d.ifcvtr.Resources.CommandLineHelp", typeof(CommandLineOptions).Assembly);
        }

        private static ResourceManager resourceManager;

        public static string DescriptionConverter(string description, string name)
        {
            var value = resourceManager.GetString(description.Replace("-", "_"));
            Nintendo.Foundation.Contracts.Assertion.Operation.True(!string.IsNullOrEmpty(value));
            return value;
        }

        [CommandLineOption('s', "silent", Description = "silent", DescriptionConverterName = "DescriptionConverter")]
        public bool Silent { get; set; }

        [CommandLineOption('j', "jobs", Description = "jobs", DescriptionConverterName = "DescriptionConverter", ValueName = "number")]
        public int Job { get; set; }

        [CommandLineValues(CountMin = 1, Description = "paths", ValueName = "paths", DescriptionConverterName = "DescriptionConverter")]
        public string[] Paths { get; set; }

        [CommandLineOption("disable-invert-uv", Description = "disable-invert-uv", DescriptionConverterName = "DescriptionConverter")]
        public bool DisableInvertUv { get; set; }

        [CommandLineOption("magnify", Description = "magnify", DescriptionConverterName = "DescriptionConverter", DefaultValue = 1.0f)]
        public float Magnify { get; set; }

        [CommandLineOption("texture-format-srgb", Description = "texture-format-srgb", DescriptionConverterName = "DescriptionConverter")]
        public bool TextureFormatSrgb { get; set; }

        [CommandLineOption('o', "output", Description = "output", DescriptionConverterName = "DescriptionConverter")]
        public string Output { get; set; }

        [CommandLineArgFileOption("args-file", Description = "args-file", DescriptionConverterName = "DescriptionConverter")]
        public string ArgsFile { get; set; }

        [CommandLineOption("project-root", Description = "project-root", DescriptionConverterName = "DescriptionConverter")]
        public string ProjectRoot { get; set; }

        [CommandLineOption("gpu-encoding", Description = "gpu-encoding", DescriptionConverterName = "DescriptionConverter")]
        public string GpuEncoding { get; set; } = "true";

        [CommandLineOption("disable-texture", Description = "disable-texture", DescriptionConverterName = "DescriptionConverter")]
        public bool DisableTexture { get; set; }

        [CommandLineOption("disable-original-image", Description = "disable-original-image", DescriptionConverterName = "DescriptionConverter")]
        public bool DisableOriginalImage { get; set; }
    }
}
