﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;
using System.Reflection;
using System.Runtime;
using nw.g3d.iflib;
using nw.g3d.nw4f_3dif;
using nw.g3d.toollib;
using System.Resources;

namespace nw.g3d.a2b
{
    // 中間ファイルバイナリコンバータ
    public class g3da2b : SimpleFilterTool<SimpleFilterToolParamsNotRequireXsdCheck>
    {
        // エントリポイント
        public static void Main()
        {
            string path = Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location);
            ProfileOptimization.SetProfileRoot(path);
            ProfileOptimization.StartProfile(Path.GetFileNameWithoutExtension(
                Assembly.GetExecutingAssembly().Location) + ".JIT.Profile");

            var helpResourceManager = new ResourceManager("nw.g3d.a2b.Resources.CommandLineHelp", typeof(g3da2b).Assembly);
            SimpleFilterToolParams.CustomDescriptionConverterFunc = (x, y) =>
            {
                return helpResourceManager.GetString(x);
            };

            g3da2b g3da2b = new g3da2b();
            G3dToolUtility.Run(delegate { g3da2b.Run(); });
        }

        // コンストラクタ
        public g3da2b() : base("nw.g3d.a2b.Resources.StringResource") { }

        // ファイルパスのチェック
        protected override bool CheckFilePath(string filePath)
        {
            if (!G3dPath.IsTextPath(filePath)) { return false; }
            return base.CheckFilePath(filePath);
        }

        // ファイル処理
        protected override void ProcessFile(int index, string filePath)
        {
            nw4f_3difType nw4f_3dif = IfTextReadUtility.Read(filePath, this.XsdBasePath);
            string binaryPath = G3dPath.ToBinaryPath(filePath);
            IfBinaryWriteUtility.Write(nw4f_3dif, binaryPath, this.XsdBasePath);
        }
    }
}
