﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gfx/gfx_ResUserData.h>
#include <g3dif/UserData.h>
#include <bindefs.h>
#include <BinaryBlock.h>

namespace nn {
namespace g3dTool {


//! @brief ユーザーデータのバイナリ化を行うクラスです。
class BinUserData : public BinaryBlock
{
public:
    BinUserData()
        : BinaryBlock()
        , m_pElem(nullptr)
        , m_DataCount(0)
        , m_Chunk()
    {
    }

    void Build(std::shared_ptr<Context> pCtx, const nw::g3d::tool::g3dif::elem_user_data& elem);
    virtual void CalculateSize();
    virtual void Convert( std::shared_ptr<Context> pCtx );

    virtual void DumpLog() const
    {
        PRINT_SYSTEM_LOG("UserData : %hs", m_pElem->name.value.c_str());
    }

private:
    const nw::g3d::tool::g3dif::elem_user_data* m_pElem;
    int m_DataCount;

    enum ChunkType
    {
        ChunkType_Data,
        ChunkType_StrPtrArray,	// nn::util::BinPtrToWString* または nn::util::BinPtrToString* の配列の領域です。string/wstring が同時に使用される事はないので共有します。
        ChunkType_Count
    };

    Chunk m_Chunk[ChunkType_Count];
};

}
}
