﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/g3d_ResSkeletalAnim.h>
#include <g3dif/SkeletalAnim.h>
#include <bindefs.h>
#include <BinaryBlock.h>
#include <BinDictionary.h>
#include <BinAnimCurve.h>
#include <BinUserData.h>

namespace nn {
namespace g3dTool {

//! @brief ボーンごとのアニメーションデータのバイナリ化を行うクラスです。
class BinBoneAnim : public BinaryBlock
{
public:
    BinBoneAnim()
        : BinaryBlock()
        , m_pElem(nullptr)
        , m_pBoneAnimTargetElemArray()
        , m_CurveArray()
        , m_RotateMode(nw::g3d::tool::g3dif::elem_skeleton_info::euler_xyz)
        , m_BeginCurve(0)
    {
    }

    void Build(std::shared_ptr<Context> pCtx, const nw::g3d::tool::g3dif::elem_bone_anim& elem);
    virtual void CalculateSize();
    virtual void CalculateOffset( std::shared_ptr<Context> pCtx );
    virtual void Convert( std::shared_ptr<Context> pCtx );

    virtual void DumpLog() const
    {
        PRINT_SYSTEM_LOG("BoneAnim : %hs", m_pElem->bone_name.value.c_str());
    }

    void SetBeginCurve(int beginCurve) { this->m_BeginCurve = beginCurve; }
    int GetCurveCount() const { return static_cast<int>(m_CurveArray.size()); }
    void SetRotateMode(nw::g3d::tool::g3dif::elem_skeleton_info::enum_rotate_mode rotateMode)
    {
        m_RotateMode = rotateMode;

        // Quaternion の場合は Degree ではないので無効にする。
        if (m_RotateMode == nw::g3d::tool::g3dif::elem_skeleton_info::quaternion)
        {
            for (auto iter = m_CurveArray.begin(); iter != m_CurveArray.end(); ++iter)
            {
                iter->SetDegreeValue(false);
            }
        }
    }

private:
    const nw::g3d::tool::g3dif::elem_bone_anim* m_pElem;

    std::vector<const nw::g3d::tool::g3dif::elem_bone_anim_target*> m_pBoneAnimTargetElemArray;
    std::vector<BinAnimCurve> m_CurveArray;
    nw::g3d::tool::g3dif::elem_skeleton_info::enum_rotate_mode m_RotateMode;
    int m_BeginCurve;

    enum
    {
        ChunkType_BaseValue,
        ChunkType_Curve,
        ChunkType_Count
    };

    Chunk m_Chunk[ChunkType_Count];
};

//! @brief スケルタルアニメーションデータのバイナリ化を行うクラスです。
class BinSkeletalAnim : public BinaryBlock
{
public:
    BinSkeletalAnim()
        : BinaryBlock()
        , m_pElem(nullptr)
        , m_BoneAnimArray()
        , m_CurveCount(0)
        , m_DicUserData()
        , m_UserDataArray()
    {
    }

    void Build(std::shared_ptr<Context> pCtx, const nw::g3d::tool::g3dif::elem_skeletal_anim& elem);
    virtual void CalculateSize();
    virtual void CalculateOffset( std::shared_ptr<Context> pCtx );
    virtual void Convert( std::shared_ptr<Context> pCtx );
    virtual void Adjust( std::shared_ptr<Context> pCtx );

    virtual void DumpLog() const
    {
        PRINT_SYSTEM_LOG("SkeletalAnim : %hs", m_pElem->name.c_str());
    }

private:
    const nw::g3d::tool::g3dif::elem_skeletal_anim* m_pElem;

    std::vector<BinBoneAnim> m_BoneAnimArray;
    int m_CurveCount;

    BinDictionary m_DicUserData;
    std::vector<BinUserData> m_UserDataArray;

    enum ChunkType
    {
        ChunkType_BindIndex,
        ChunkType_BoneAnim,
        ChunkType_UserDataData,
        ChunkType_Count
    };

    Chunk m_Chunk[ChunkType_Count];
};

}
}
