﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/g3d_ResMaterialAnim.h>
#include <g3dif/MaterialAnim.h>
#include <bindefs.h>
#include <BinaryBlock.h>
#include <BinDictionary.h>
#include <BinAnimCurve.h>
#include <BinUserData.h>


namespace nn {
namespace g3dTool {

//! @brief マテリアルごとのアニメーションデータのバイナリ化を行うクラスです。
class BinPerMaterialAnim : public BinaryBlock
{
public:
    BinPerMaterialAnim()
        : BinaryBlock()
        , m_pElem(nullptr)
        , m_CurveArray()
        , m_BeginCurve(0)
        , m_BeginParam(0)
        , m_ShaderParamCurveCount(0)
        , m_TexPatternCurveCount(0)
        , m_MatVisAnimCurveCount(0)
        , m_ShaderParamConstantCount(0)
        , m_TexPatternConstantCount(0)
        , m_MatVisConstantCount(0)
        , m_ConstantCount(0)
    {
        for( int chunkIndex = 0; chunkIndex < ChunkType_Count; chunkIndex++ )
        {
            m_Chunk[ chunkIndex ].size		= 0;
            m_Chunk[ chunkIndex ].alignment	= 0;
            m_Chunk[ chunkIndex ].offset	= -1;
        }
    }

    void Build(std::shared_ptr<Context> pCtx, const nw::g3d::tool::g3dif::elem_nn_per_material_anim& elem);
    virtual void CalculateSize();
    virtual void CalculateOffset( std::shared_ptr<Context> pCtx );
    virtual void Convert( std::shared_ptr<Context> pCtx );

    virtual void DumpLog() const
    {
        PRINT_SYSTEM_LOG("PerMaterialAnim : %hs", std::string("") + m_pElem->mat_name.value.c_str());
    }

    uint16_t GetCurveCount() const { return static_cast<uint16_t>(m_CurveArray.size()); }
    uint16_t GetParamCount() const
    {
        uint16_t paramCount = 0;
        for (auto iter = m_pElem->shader_param_anim_array.Get().cbegin(); iter != m_pElem->shader_param_anim_array.Get().cend(); ++iter)
        {
            paramCount += static_cast<uint16_t>(iter->param_anim_target_array.size());
        }
        return paramCount;
    }

    void SetBeginCurve(uint16_t beginCurve) { this->m_BeginCurve = beginCurve; }
    void SetBeginParam(uint16_t beginTexture) { this->m_BeginParam = beginTexture; }

private:
    const nw::g3d::tool::g3dif::elem_nn_per_material_anim* m_pElem;

    std::vector<BinAnimCurve> m_CurveArray;
    uint16_t m_ShaderParamCurveCount;
    uint16_t m_TexPatternCurveCount;
    uint16_t m_MatVisAnimCurveCount;
    uint16_t m_BeginCurve;
    uint16_t m_BeginParam;
    uint16_t m_ShaderParamConstantCount;
    uint16_t m_TexPatternConstantCount;
    uint16_t m_MatVisConstantCount;
    uint16_t m_ConstantCount;

    enum
    {
        ChunkType_ParamInfo,
        ChunkType_TexInfo,
        ChunkType_Constant,
        ChunkType_Curve,
        ChunkType_Count
    };

    Chunk m_Chunk[ChunkType_Count];
};

}
}
