﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once


#include <g3dif/Model.h>
#include <bindefs.h>

#if defined( near ) && defined( far )	// windows.h で両方 define される
#undef near
#undef far
#include <nn/g3d/g3d_ResModel.h>	// nn:util:math で near, far を使用している
#define near
#define far
#else
#include <nn/g3d/g3d_ResModel.h>
#endif

#include <BinaryBlock.h>
#include <BinDictionary.h>
#include <BinUserData.h>
#include <BinSkeleton.h>
#include <BinShape.h>
#include <BinVertex.h>
#include <BinMaterial.h>

namespace nn {
namespace g3dTool {


//! @brief モデルデータのバイナリ化を行うクラスです。
class BinModel : public BinaryBlock
{
public:
    BinModel()
        : BinaryBlock()
        , m_pElem(nullptr)
        , m_Skeleton()
        , m_ShapeArray()
        , m_VertexArray()
        , m_MaterialArray()
        , m_UserDataArray()
    {
        for( int i = 0; i < ChunkType_Count; i++ )
        {
            m_Chunk[ i ].size		= 0;
            m_Chunk[ i ].alignment	= 0;
            m_Chunk[ i ].offset		= -1;
        }
    }

    void Build(std::shared_ptr<Context> pCtx, const nw::g3d::tool::g3dif::elem_model& elem);
    virtual void CalculateSize();
    virtual void CalculateOffset( std::shared_ptr<Context> pCtx );
    virtual void Convert( std::shared_ptr<Context> pCtx );

    virtual void DumpLog() const
    {
        PRINT_SYSTEM_LOG("Model : %hs", m_pElem->name.c_str());
    }

private:
    void ConvertVertex(nn::g3d::ResModelData &model, std::shared_ptr<Context> pCtx );

private:
    const nw::g3d::tool::g3dif::elem_model* m_pElem;

    BinDictionary m_DicShape;
    BinDictionary m_DicMaterial;
    BinDictionary m_DicUserData;

    nw::g3d::tool::util::Optional<BinSkeleton> m_Skeleton;
    std::vector<BinShape> m_ShapeArray;
    std::vector<BinVertex> m_VertexArray;
    std::vector<BinMaterial> m_MaterialArray;
    std::vector<BinUserData> m_UserDataArray;

    enum ChunkType
    {
        ChunkType_Vtx,
        ChunkType_MatArray,
        ChunkType_ShapeArray,
        ChunkType_UserDataArray,
        ChunkType_Count
    };

    Chunk m_Chunk[ChunkType_Count];
};



}
}
