﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/g3d_ResMaterialAnim.h>
#include <g3dif/VisibilityAnim.h>
#include <bindefs.h>
#include <BinaryBlock.h>
#include <BinDictionary.h>
#include <BinAnimCurve.h>
#include <BinUserData.h>

namespace nn {
namespace g3dTool {

//! @brief マテリアルビジビリティアニメーションデータのバイナリ化を行うクラスです。
class BinMatVisibilityAnim : public BinaryBlock
{
public:
    BinMatVisibilityAnim()
        : BinaryBlock()
        , m_pElem(nullptr)
        , m_CurveArray()
        , m_DicUserData()
        , m_UserDataArray()
    {
        for( int chunkIndex = 0; chunkIndex < ChunkType_Count; chunkIndex++ )
        {
            m_Chunk[ chunkIndex ].size		= 0;
            m_Chunk[ chunkIndex ].alignment	= 0;
            m_Chunk[ chunkIndex ].offset	= -1;
        }
    }

    void Build(std::shared_ptr<Context> pCtx, const nw::g3d::tool::g3dif::elem_mat_visibility_anim& elem);
    virtual void CalculateSize();
    virtual void CalculateOffset(std::shared_ptr<Context> pCtx);
    virtual void Convert(std::shared_ptr<Context> pCtx);
    virtual void Adjust(std::shared_ptr<Context> pCtx);

    virtual void DumpLog() const
    {
        PRINT_SYSTEM_LOG("MaterialVisibilityAnim : %hs", m_pElem->name.c_str());
    }

private:
    const nw::g3d::tool::g3dif::elem_mat_visibility_anim* m_pElem;
    std::vector<BinAnimCurve> m_CurveArray;

    BinDictionary m_DicUserData;
    std::vector<BinUserData> m_UserDataArray;

    enum ChunkType
    {
        ChunkType_PerMaterialAnimDataArray,
        ChunkType_BindIndex,
        //ChunkType_Name,		//!< string pool に登録するので不要。
        ChunkType_Curve,
        ChunkType_BaseValue,
        ChunkType_UserDataData,
        ChunkType_Count
    };

    Chunk m_Chunk[ChunkType_Count];
};

} // namespace cvtr
} // namespace tool
