﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once


#include <g3dif/Material.h>
#include <bindefs.h>

#if defined( near ) && defined( far )	// windows.h で両方 define される
#undef near
#undef far
#include <nn/g3d/g3d_ResMaterial.h>	// nn:util:math で near, far を使用している
#define near
#define far
#else
#include <nn/g3d/g3d_ResMaterial.h>
#endif

#include <BinaryBlock.h>
#include <BinDictionary.h>
#include <BinUserData.h>

namespace nn {
namespace g3dTool {

class BinShaderAssign : public BinaryBlock
{
public:
    BinShaderAssign()
        : BinaryBlock()
        , m_pElem(nullptr)
        , m_DicAttribAssign()
        , m_DicSamplerAssign()
        , m_DicShaderOption()
    {
        for( int i = 0; i < ChunkType_Count; i++ )
        {
            m_Chunk[ i ].size = 0;
            m_Chunk[ i ].offset = -1;
            m_Chunk[ i ].alignment = 0;
        }
    }

    void Build(std::shared_ptr<Context> pCtx, const nw::g3d::tool::g3dif::elem_shader_assign& elem);
    virtual void CalculateSize();
    virtual void Convert( std::shared_ptr<Context> pCtx );

    virtual void DumpLog() const
    {
        PRINT_SYSTEM_LOG("ShaderAssign : %hs >> %hs", m_pElem->shader_archive.value.c_str(), m_pElem->shading_model.value.c_str());
    }

private:
    const nw::g3d::tool::g3dif::elem_shader_assign* m_pElem;

    BinDictionary m_DicAttribAssign;
    BinDictionary m_DicSamplerAssign;	//!< key は sahder 内 uniform sampler のアノテーション
    BinDictionary m_DicShaderOption;

    enum ChunkType
    {
        ChunkType_ShaderAssign,
        ChunkType_AttributeAssignStrPtrArray,
        ChunkType_SamplerAssignStrPtrArray,
        ChunkType_ShaderOptionStrPtrArray,
        ChunkType_Count
    };

    Chunk m_Chunk[ChunkType_Count];
};

//! @brief マテリアルデータのバイナリ化を行うクラスです。
class BinMaterial : public BinaryBlock
{
public:
    struct ShaderParameterSize
    {
        size_t srcSize;
        size_t srcOffset;
    };

    struct ShaderParamDepend
    {
        int depend;
        int depended;
    };

    BinMaterial()
        : BinaryBlock()
        , m_pElem(nullptr)
        , m_Index(-1)
        , m_DicRenderInfo()
        , m_DicSampler()
        , m_DicShaderParam()
        , m_DicUserData()
        , m_ShaderAssign()
        , m_UserDataArray()
        , m_MaterialBuffer()
        , m_SrcParamSize(0)
        , m_ShaderParamArray()
    {
        for( int i = 0; i < ChunkType_Count; i++ )
        {
            m_Chunk[ i ].size	= 0;
            m_Chunk[ i ].offset = -1;
            m_Chunk[ i ].alignment = 0;
        }
    }

    void Build(std::shared_ptr<Context> pCtx, const nw::g3d::tool::g3dif::elem_material& elem);
    virtual void CalculateSize();
    virtual void CalculateOffset( std::shared_ptr<Context> pCtx ) override;
    virtual void Convert( std::shared_ptr<Context> pCtx);

    virtual void DumpLog() const
    {
        PRINT_SYSTEM_LOG("Material : %hs", m_pElem->name.value.c_str());
    }

    void CalculateSamplerArraySize( void );

    void ConvertRenderInfo(nn::g3d::ResMaterialData& material, std::shared_ptr<Context> pCtx );
    void ConvertGfxSampler( nn::g3d::ResMaterialData& material, std::shared_ptr<Context> pCtx );
    void ConvertShaderParam(nn::g3d::ResMaterialData& material, std::shared_ptr<Context> pCtx);

    void SetIndex(int index)
    {
        this->m_Index = index;
    }

private:
    const nw::g3d::tool::g3dif::elem_material* m_pElem;

    int m_Index;

    BinDictionary m_DicRenderInfo;
    BinDictionary m_DicSampler;
    BinDictionary m_DicShaderParam;
    BinDictionary m_DicUserData;

    BinShaderAssign m_ShaderAssign;
    std::vector<BinUserData> m_UserDataArray;
    std::vector<ShaderParameterSize> m_MaterialBuffer;
    size_t m_SrcParamSize;
    std::vector<const nw::g3d::tool::g3dif::elem_shader_param*> m_ShaderParamArray;
    std::vector<ShaderParamDepend> m_ShaderParamDepends;

    enum ChunkType
    {
        ChunkType_RenderInfo,
        ChunkType_GfxTextureViewPtrArray,
        ChunkType_Sampler,
        ChunkType_MatShaderParam,
        ChunkType_MatBuff,
        ChunkType_VolatileFlag,
        ChunkType_UserDataArray,
        ChunkType_SamplerDescriptorSlotArray,
        ChunkType_TextureDescriptorSlotArray,
        ChunkType_TextureNamePtrArray,
        ChunkType_Count
    };

    Chunk m_Chunk[ChunkType_Count];
};

}
}
