﻿namespace G3dCore.Windows.Actions
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows;
    using System.Windows.Interactivity;
    using G3dCore.Messaging;
    using G3dCore.Resources;
    using Microsoft.Win32;

    /// <summary>
    /// ファイル保存ダイアログを表示するアクション
    /// </summary>
    public class SaveFileDialogAction : TriggerAction<DependencyObject>
    {
        /// <summary>
        /// アクションを呼び出します。
        /// </summary>
        /// <param name="parameter">アクションへのパラメーター。</param>
        protected override void Invoke(object parameter)
        {
            var args = parameter as MessageEventArgs;
            if (args != null)
            {
                InputArg argInput = (InputArg)args.Message.Body;
                OutputArg argOutput = new OutputArg();

                SaveFileDialog sfd = new SaveFileDialog();
                sfd.Title = argInput.Title;
                sfd.FileName = argInput.FileName;
                sfd.Filter = argInput.Filter;
                sfd.FilterIndex = argInput.FilterIndex;
                sfd.InitialDirectory = argInput.InitialDirectory;

                if (sfd.ShowDialog() == true)
                {
                    argOutput.Result = true;
                    argOutput.FilePath = sfd.FileName;
                }
                else
                {
                    argOutput.Result = false;
                }

                args.Message.Response = argOutput;
                args.Callback(args.Message);
            }
        }

        public class InputArg
        {
            public string Title { get; set; }
            public string FileName { get; set; }
            public string Filter { get; set; }
            public int FilterIndex { get; set; }
            public string InitialDirectory { get; set; }

            public InputArg()
            {
                Title = Labels.SaveAs;
                FilterIndex = 1;
            }
        }

        public class OutputArg
        {
            public bool Result { get; internal set; }
            public string FilePath { get; set; }
        }
    }
}
