﻿namespace G3dCore.Windows.Actions
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows;
    using System.Windows.Interactivity;
    using G3dCore.Messaging;
    using G3dCore.Resources;
    using Microsoft.Win32;

    /// <summary>
    /// ファイルを開くダイアログを表示するアクション
    /// </summary>
    public class OpenFileDialogAction : TriggerAction<DependencyObject>
    {
        /// <summary>
        /// アクションを呼び出します。
        /// </summary>
        /// <param name="parameter">アクションへのパラメーター。</param>
        protected override void Invoke(object parameter)
        {
            var args = parameter as MessageEventArgs;
            if (args != null)
            {
                var input = (InputArg)args.Message.Body;
                var output = new OutputArg();

                OpenFileDialog ofd = new OpenFileDialog();
                ofd.Title = input.Title;
                ofd.FileName = input.FileName;
                ofd.Filter = input.Filter;
                ofd.FilterIndex = input.FilterIndex;
                ofd.InitialDirectory = input.InitialDirectory;

                if (ofd.ShowDialog() == true)
                {
                    output.Result = true;
                    output.FileName = ofd.FileName;
                }
                else
                {
                    output.Result = false;
                }

                args.Message.Response = output;
                args.Callback(args.Message);
            }
        }

        public class InputArg
        {
            public string Title { get; set; }
            public string FileName { get; set; }
            public string Filter { get; set; }
            public int FilterIndex { get; set; }
            public string InitialDirectory { get; set; }

            public InputArg()
            {
                Title = Labels.Open;
                FilterIndex = 1;
            }
        }

        public class OutputArg
        {
            public bool Result { get; internal set; }
            public string FileName { get; internal set; }
        }
    }
}
