﻿namespace G3dCore.Windows.Actions
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows;
    using System.Windows.Forms;
    using System.Windows.Interactivity;
    using G3dCore.Messaging;

    /// <summary>
    /// フォルダ選択ダイアログを表示するアクション
    /// </summary>
    public class FolderBrowserDialogAction : TriggerAction<DependencyObject>
    {
        /// <summary>
        /// アクションを呼び出します。
        /// </summary>
        /// <param name="parameter">アクションへのパラメーター。</param>
        protected override void Invoke(object parameter)
        {
            var args = parameter as MessageEventArgs;
            if (args != null)
            {
                InputArg argInput = (InputArg)args.Message.Body;
                OutputArg argOutput = new OutputArg();

                FolderBrowserDialog fbd = new FolderBrowserDialog();
                fbd.SelectedPath = argInput.SelectedPath;
                fbd.Description = argInput.Description;

                if (fbd.ShowDialog() == DialogResult.OK)
                {
                    argOutput.Result = true;
                    argOutput.SelectedPath = fbd.SelectedPath;
                }
                else
                {
                    argOutput.Result = false;
                }

                args.Message.Response = argOutput;
                args.Callback(args.Message);
            }
        }

        public class InputArg
        {
            public string SelectedPath { get; set; }
            public string Description { get; set; }
        }

        public class OutputArg
        {
            public bool Result { get; internal set; }
            public string SelectedPath { get; set; }
        }
    }
}
