﻿namespace G3dCore.Utilities
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;
    using System.Runtime.CompilerServices;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.App;

    /// <summary>
    /// ログユーティリティクラスです。
    /// </summary>
    public static class LogUtility
    {
        /// <summary>
        /// デバッグメッセージを書き込みます。
        /// </summary>
        /// <param name="message">書き込むメッセージです。</param>
        /// <param name="fileName">ファイル名です。記述した場所を自動的に入れるので設定不要です。</param>
        /// <param name="fileLine">ファイル行です。記述した場所を自動的に入れるので設定不要です。</param>
        /// <param name="memberName">メンバー名です。記述した場所を自動的に入れるので設定不要です。</param>
        [Conditional("DEBUG")]
        public static void WriteDebug(string message, [CallerFilePath] string fileName = null, [CallerLineNumber] int fileLine = 0, [CallerMemberName] string memberName = null)
        {
            AppManager.WriteDebug(message, fileName, fileLine, memberName);
        }

        /// <summary>
        /// エラーメッセージを書き込みます。
        /// </summary>
        /// <param name="message">書き込むメッセージです。</param>
        /// <param name="exception">例外処理のインスタンスです。ログに例外時の情報を入力したい場合に使用します。</param>
        /// <param name="associatedAction">ログに関連付ける処理です。</param>
        /// <param name="fileName">ファイル名です。記述した場所を自動的に入れるので設定不要です。</param>
        /// <param name="fileLine">ファイル行です。記述した場所を自動的に入れるので設定不要です。</param>
        /// <param name="memberName">メンバー名です。記述した場所を自動的に入れるので設定不要です。</param>
        public static void WriteError(
            string message,
            Exception exception = null,
            System.Action associatedAction = null,
            [CallerFilePath] string fileName = null,
            [CallerLineNumber] int fileLine = 0,
            [CallerMemberName] string memberName = null)
        {
            ShowLogOutputToolPane();
            AppManager.WriteError(message, exception, associatedAction, fileName, fileLine, memberName);
        }

        /// <summary>
        /// 情報メッセージを書き込みます。
        /// </summary>
        /// <param name="message">書き込むメッセージです。</param>
        /// <param name="fileName">ファイル名です。記述した場所を自動的に入れるので設定不要です。</param>
        /// <param name="fileLine">ファイル行です。記述した場所を自動的に入れるので設定不要です。</param>
        /// <param name="memberName">メンバー名です。記述した場所を自動的に入れるので設定不要です。</param>
        public static void WriteInfo(string message, [CallerFilePath] string fileName = null, [CallerLineNumber] int fileLine = 0, [CallerMemberName] string memberName = null)
        {
            AppManager.WriteInfo(message, fileName, fileLine, memberName);
        }

        /// <summary>
        /// ユーザ通知用メッセージを書き込みます。
        /// </summary>
        /// <param name="message">書き込むメッセージです。</param>
        /// <param name="fileName">ファイル名です。記述した場所を自動的に入れるので設定不要です。</param>
        /// <param name="fileLine">ファイル行です。記述した場所を自動的に入れるので設定不要です。</param>
        /// <param name="memberName">メンバー名です。記述した場所を自動的に入れるので設定不要です。</param>
        public static void WriteUserMessage(string message, [CallerFilePath] string fileName = null, [CallerLineNumber] int fileLine = 0, [CallerMemberName] string memberName = null)
        {
            ShowLogOutputToolPane();
            AppManager.WriteUserMessage(message, fileName, fileLine, memberName);
        }

        /// <summary>
        /// 警告メッセージを書き込みます。
        /// </summary>
        /// <param name="message">書き込むメッセージです。</param>
        /// <param name="exception">登録する例外です。</param>
        /// <param name="associatedAction">ログに関連付ける処理です。</param>
        /// <param name="fileName">ファイル名です。記述した場所を自動的に入れるので設定不要です。</param>
        /// <param name="fileLine">ファイル行です。記述した場所を自動的に入れるので設定不要です。</param>
        /// <param name="memberName">メンバー名です。記述した場所を自動的に入れるので設定不要です。</param>
        public static void WriteWarning(string message, Exception exception = null, Action associatedAction = null, [CallerFilePath] string fileName = null, [CallerLineNumber] int fileLine = 0, [CallerMemberName] string memberName = null)
        {
            ShowLogOutputToolPane();
            AppManager.WriteWarning(message, exception, associatedAction, fileName, fileLine, memberName);
        }

        private static void ShowLogOutputToolPane()
        {
            try
            {
                AppManager.AddTool(Properties.Resources.LogOutputToolPaneKey);
            }
            catch (Exception)
            {
                // 重要な処理ではないので特に何もしない
            }
        }
    }
}
