﻿namespace G3dCore.Modules.ErrorView
{
    using System;
    using System.Collections.Generic;
    using System.Collections.ObjectModel;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows;
    using G3dCore.Messaging;

    /// <summary>
    /// エラービューを管理するクラスです。
    /// </summary>
    public static class ErrorViewManager
    {
        /// <summary>
        /// エラービューダイアログを表示します。
        /// </summary>
        /// <param name="errorViewLogger">エラービューロガーです。</param>
        public static void ShowErrorViewDialog(ErrorViewLogger errorViewLogger)
        {
            var action = new ErrorViewDialogAction();
            var manualTrigger = new ManualTrigger();
            manualTrigger.Actions.Add(action);

            var input = new ErrorViewDialogAction.InputArg()
            {
                ErrorViewLogger = errorViewLogger
            };

            var eventArgs = new MessageEventArgs(
                new Message(input),
                m =>
                {
                });

            manualTrigger.Invoke(eventArgs);
        }
    }
}
