﻿namespace G3dCore.Modules.ErrorView
{
    using System;
    using System.Collections.Generic;
    using System.Collections.ObjectModel;
    using System.ComponentModel;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows.Data;

    /// <summary>
    /// エラービューロガークラスです。
    /// </summary>
    public class ErrorViewLogger : IDisposable
    {
        private readonly ObservableCollection<ErrorViewLog> logs = new ObservableCollection<ErrorViewLog>();
        private bool isDialogShown = false;

        /// <summary>
        /// エラービューログビューモデルを取得します。
        /// </summary>
        public ICollectionView ErrorViewLogs
        {
            get
            {
                return CollectionViewSource.GetDefaultView(this.logs);
            }
        }

        /// <summary>
        /// 表示内容が無くてもエラー表示を行うかどうかを取得設定します。
        /// </summary>
        public bool ShowEvenIfEmpty
        {
            get;
            set;
        }

        /// <summary>
        /// ログを追加します。
        /// </summary>
        /// <param name="logs">追加するログです。</param>
        public void Add(params ErrorViewLog[] logs)
        {
            foreach (var log in logs)
            {
                this.logs.Add(log);
            }
        }

        /// <summary>
        /// ログを表示します。
        /// </summary>
        public void Show()
        {
            this.isDialogShown = true;

            if (this.logs.FirstOrDefault() == null && !this.ShowEvenIfEmpty)
            {
                return;
            }

            ErrorViewManager.ShowErrorViewDialog(this);
        }

        /// <summary>
        /// Dispose() 時にエラーログがある場合にはダイアログを表示します。
        /// </summary>
        public void Dispose()
        {
            if (!this.isDialogShown)
            {
                this.Show();
            }
        }
    }
}
