﻿namespace G3dCore.Modules.ErrorView
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.ViewModels;

    /// <summary>
    /// エラービュー用のログのクラスです。
    /// </summary>
    public class ErrorViewLog : ViewModel
    {
        private CategoryType category = CategoryType.None;
        private string summary = string.Empty;
        private string details = string.Empty;

        /// <summary>
        /// ログの種類を表します。
        /// </summary>
        public enum CategoryType
        {
            /// <summary>
            /// 種類無し
            /// </summary>
            None,

            /// <summary>
            /// エラー
            /// </summary>
            Error,

            /// <summary>
            /// 警告
            /// </summary>
            Warning,

            /// <summary>
            /// 情報
            /// </summary>
            Info
        }

        /// <summary>
        /// ログの種類を取得設定します。
        /// </summary>
        public CategoryType Category
        {
            get
            {
                return this.category;
            }

            set
            {
                if (value != this.category)
                {
                    this.category = value;
                    this.RaisePropertyChanged();
                }
            }
        }

        /// <summary>
        /// サマリーを取得設定します。
        /// </summary>
        public string Summary
        {
            get
            {
                return this.summary;
            }

            set
            {
                if (value != this.summary)
                {
                    this.summary = value;
                    this.RaisePropertyChanged();
                }
            }
        }

        /// <summary>
        /// 詳細を取得設定します。
        /// </summary>
        public string Details
        {
            get
            {
                return this.details;
            }

            set
            {
                if (value != this.details)
                {
                    this.details = value;
                    this.RaisePropertyChanged();
                }
            }
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public ErrorViewLog()
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="category">ログの種類です。</param>
        public ErrorViewLog(CategoryType category)
        {
            this.category = category;
        }
    }
}
