﻿namespace G3dCore.Modules.ErrorView
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.ViewModels;

    /// <summary>
    /// エラービューダイアログのビューモデルです。
    /// </summary>
    public class ErrorViewDialogViewModel : ViewModel
    {
        private WeakReference<ErrorViewLogger> logger;
        private ErrorViewLog selectedErrorViewLog = null;
        private string selectedDetails = string.Empty;

        /// <summary>
        /// エラービューログビューモデルを取得します。
        /// </summary>
        public ICollectionView ErrorViewLogs
        {
            get
            {
                ErrorViewLogger data;
                if (this.logger.TryGetTarget(out data))
                {
                    return data.ErrorViewLogs;
                }

                return null;
            }
        }

        /// <summary>
        /// 選択エラービューログビューモデルを取得設定します。
        /// </summary>
        public ErrorViewLog SelectedErrorViewLog
        {
            get
            {
                return this.selectedErrorViewLog;
            }

            set
            {
                if (value != this.selectedErrorViewLog)
                {
                    this.selectedErrorViewLog = value;
                    this.RaisePropertyChanged();
                }
            }
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="errorViewLogger">エラービューロガーです。</param>
        public ErrorViewDialogViewModel(ErrorViewLogger errorViewLogger)
        {
            this.logger = new WeakReference<ErrorViewLogger>(errorViewLogger);

            this.SelectedErrorViewLog = this.ErrorViewLogs.CurrentItem as ErrorViewLog;
        }
    }
}
