﻿namespace G3dCore.Extensions
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using G3dCore.Entities;
    using Opal.Operations;

    /// <summary>
    /// シェーダ設定定義のオペレーション拡張メソッドです。
    /// </summary>
    public static class ShaderOperationExtension
    {
        /// <summary>
        /// シェーダ設定定義の基本情報を編集するオペレーションを生成します。
        /// </summary>
        /// <param name="shader">データモデルです。</param>
        /// <param name="name">名前です。</param>
        /// <param name="isMaterialShader">マテリアルシェーダかどうかです。</param>
        /// <param name="vertexShaderPath">頂点シェーダパスです。</param>
        /// <param name="geometryShaderPath">ジオメトリシェーダパスです。</param>
        /// <param name="fragmentShaderPath">フラグメントシェーダパスです。</param>
        /// <param name="computeShaderPath">演算シェーダパスです。</param>
        /// <returns>生成したオペレーションを返します。</returns>
        public static Operation CreateEditOperation(
            this Shader shader,
            string name,
            bool isMaterialShader,
            string vertexShaderPath,
            string geometryShaderPath,
            string fragmentShaderPath,
            string computeShaderPath)
        {
            OperationSet operation = new OperationSet();
            operation.Add(new PropertyEditOperation<Shader, string>(shader, "Name", name));
            operation.Add(new PropertyEditOperation<Shader, bool>(shader, "MaterialShader", isMaterialShader));
            operation.Add(new PropertyEditOperation<VertexShader, string>(shader.VertexShader, "Path", vertexShaderPath));
            operation.Add(new PropertyEditOperation<GeometryShader, string>(shader.GeometryShader, "Path", geometryShaderPath));
            operation.Add(new PropertyEditOperation<FragmentShader, string>(shader.FragmentShader, "Path", fragmentShaderPath));
            operation.Add(new PropertyEditOperation<ComputeShader, string>(shader.ComputeShader, "Path", computeShaderPath));
            return operation;
        }

        /// <summary>
        /// マクロを追加するオペレーションを生成します。
        /// </summary>
        /// <param name="shader">データモデルです。</param>
        /// <param name="name">名前です。</param>
        /// <param name="value">値です。</param>
        /// <returns>生成したオペレーションを返します。</returns>
        public static Operation CreateAddMacroOperation(this Shader shader, string name, string value)
        {
            OperationSet operation = new OperationSet();

            var macro = new Macro()
            {
                Name = name,
                Value = value
            };
            operation.Add(new ListItemAddOperation<Macro>(shader.Macros, macro));

            return operation;
        }

        /// <summary>
        /// マクロをクリアするオペレーションを生成します。
        /// </summary>
        /// <param name="shader">データモデルです。</param>
        /// <returns>生成したオペレーションを返します。</returns>
        public static Operation CreateClearMacroOperation(this Shader shader)
        {
            OperationSet operation = new OperationSet();
            operation.Add(new ListClearOperation<Macro>(shader.Macros));
            return operation;
        }
    }
}
