﻿namespace G3dCore.Extensions
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using G3dCore.Entities;
    using Opal.Operations;

    /// <summary>
    /// シェーダ設定情報のオペレーション拡張メソッドです。
    /// </summary>
    public static class ShaderConfigInfoOperationExtension
    {
        /// <summary>
        /// コードページを編集するオペレーションを生成します。
        /// </summary>
        /// <param name="shaderConfigInfo">データモデルです。</param>
        /// <param name="value">編集する値です。</param>
        /// <returns>生成したオペレーションを返します。</returns>
        public static Operation CreateEditCodePageOperation(this ShaderConfigInfo shaderConfigInfo, int value)
        {
            OperationSet operation = new OperationSet();
            operation.Add(new PropertyEditOperation<ShaderConfigInfo, int>(shaderConfigInfo, "CodePage", value));
            return operation;
        }
    }
}
