﻿namespace G3dCore.Entities
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using nw.g3d.nw4f_3dif;
    using Opal.Security.Cryptography;

    /// <summary>
    /// シェーダ設定情報のエンティティクラスです。
    /// </summary>
    public class ShaderConfigInfo : Entity<shader_config_infoType>
    {
        private int codePage = 0;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public ShaderConfigInfo()
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="data">設定するデータです。</param>
        public ShaderConfigInfo(shader_config_infoType data)
            : this()
        {
            this.codePage = data.code_page;
        }

        /// <summary>
        /// コードページを取得設定します。
        /// </summary>
        public int CodePage
        {
            get
            {
                return this.codePage;
            }

            set
            {
                this.SetProperty(ref this.codePage, value, () => this.CalcCRC());
            }
        }

        /// <summary>
        /// 現在のインスタンスのコピーである新しいオブジェクトを作成します。
        /// </summary>
        /// <returns>現在のインスタンスのコピーである新しいオブジェクトを返します。</returns>
        public override IEntity Clone()
        {
            var instance = new ShaderConfigInfo();
            instance.codePage = this.codePage;

            return instance;
        }

        /// <summary>
        /// 出力データを作成します。
        /// </summary>
        /// <returns>出力データのインスタンスを返します。</returns>
        public override shader_config_infoType CreateWriteData()
        {
            shader_config_infoType value = new shader_config_infoType();
            value.code_page = this.codePage;

            return value;
        }

        /// <summary>
        /// エンティティのCRC を作成します。（内部処理用）
        /// </summary>
        /// <returns>CRCの値を返します。</returns>
        protected override uint CreateCRCInternal()
        {
            CRC32 crc = new CRC32();
            List<byte> buffers = new List<byte>();
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.codePage)));

            var hashValue = crc.ComputeHashUInt32(buffers.ToArray());
            return hashValue;
        }
    }
}
